#include "mbed.h"
#include "USBHostMIDI.h"
DigitalOut led(LED1);
RawSerial  midi(p28, NC);
void onMidNoteOff   (uint8_t ch, uint8_t  key, uint8_t vel) { midi.putc(0x80|ch); midi.putc(key); midi.putc(vel); led = !led; }
void onMidNoteOn    (uint8_t ch, uint8_t  key, uint8_t vel) { midi.putc(0x90|ch); midi.putc(key); midi.putc(vel); led = !led; }
void onMidCtrlChg   (uint8_t ch, uint8_t   cc, uint8_t val) { midi.putc(0xB0|ch); midi.putc(cc); midi.putc(val); }
void onMidPitchBend (uint8_t ch, uint16_t val)              { midi.putc(0xE0|ch); midi.putc(val&0x7F); midi.putc(val>>7); }
void onMidExclusive (uint8_t*, uint16_t, bool)  {}
void onMid1byte     (uint8_t)                   {}
void onMid2bytes    (uint8_t, uint8_t)          {}
void onMid3bytes    (uint8_t, uint8_t, uint8_t) {}
void mid_task(void const *) {
    USBHostMIDI mid;
    mid.attachNoteOff                   (onMidNoteOff   ); mid.attachNoteOn         (onMidNoteOn    );
    mid.attachPolyKeyPress              (onMid3bytes    ); mid.attachControlChange  (onMidCtrlChg   );
    mid.attachProgramChange             (onMid2bytes    ); mid.attachChannelPressure(onMid2bytes    );
    mid.attachPitchBend                 (onMidPitchBend ); mid.attachSystemExclusive(onMidExclusive );
    mid.attachSystemCommonTwoBytes      (onMid2bytes    ); mid.attachSingleByte     (onMid1byte     );
    mid.attachSystemCommonThreeBytes    (onMid3bytes    ); mid.attachCableEvent     (onMid3bytes    );
    mid.attachMiscellaneousFunctionCode (onMid3bytes    );
    for(;;) { while(!mid.connect())  { Thread::wait(250); } led = 1;
              while(mid.connected()) { Thread::wait(250); } led = 0; }
}
int main() {
    midi.baud(31250); 
    DigitalOut hoge(P2_9); hoge = 1; // disable usb d+ pullup 
    Thread midTask(mid_task, NULL, osPriorityNormal, 1024);
    const char aMsg[] = "\xF0\x43\x79\x09\x00\x50\x10" "j M,M,e,s M,b' i,i\0" "\xF7";
    Thread::wait(3500); for(int i = 0; i < sizeof(aMsg)-1; midi.putc(aMsg[i++]));
    for(;;) { Thread::wait(250); }
}