// Cecilia Schneider
// OCE 360 Final Project 

#include "mbed.h"
#include "MMA8452Q.h"
#include "SDFileSystem.h"

// AnalogIn ain(p15); // temp sensor on p15
DigitalIn switchin(p11); // switch on p11

// Accelerometer
MMA8452Q accel(p28, p27, 0x1D); // Accelerometer - SDA, SCL, and I2C address

// Serial terminal 
Serial pc(USBTX, USBRX);

// SD card reader
SDFileSystem sd(p5, p6, p7, p8, "sd"); 

int main() {
    // initialize accelerometer
    accel.init(); 
    float x;
    float y;
    float z;

    // define and open file 
    FILE *file;
    file = fopen("/sd/acceldata.txt", "w"); 
       
    while(1){
        if (switchin == 1){ // store data from accelerometer in x, y , z
            x = accel.readX();
            y = accel.readY();
            z = accel.readZ();
            fprintf(file, "%3.2f %3.2f %3.2f \n\r", x, y, z); // write accelerometer data to file
        }
        else ()
            fclose(file); // close file here 
            file = fopen("/sd/acceldata.txt","r"); // reopen for reading 
            pc.printf("%3.2f %3.2f %3.2f \n\r", x, y, z); // print data to serial terminal 
            pc.printf("TEST");
            break; // only do this once?
    }
}






















