// Cecilia Schneider
// OCE360 Assignment 7

#include "mbed.h"
#include "SDFileSystem.h"

AnalogIn ain(p15); // temp sensor on p15
DigitalIn switchin(p11); // switch on p11
SDFileSystem sd(p5, p6, p7, p8, "sd"); // SD card reader
Serial pc(USBTX, USBRX); // USB serial display
Timer timer; // define timer object

int main() 
{
    FILE *file;
    float voltage_in;
    float degrees_c;

    timer.start(); //start timer here
    file = fopen("/sd/temp-data.txt", "w"); //open file here
    while(switchin==1) {
        voltage_in = ain * 3.3;
        degrees_c = (voltage_in - 0.5) * 100.0; //read temp data
        fprintf(file, "%2.2fs %3.1f deg C %3.1fVolts \n\r", timer.read(), degrees_c, voltage_in); //write timer and temp data to file
        wait (1);
    }
    fclose(file); //close file here
    file = fopen("/sd/temp_data.txt", "r"); //reopen file for reading
    pc.printf("%2.2fs: %3.1f deg C %3.1f Volts \n\r", timer.read(), degrees_c, voltage_in); //print data to serial terminal
}

