#include "SegDisplay.h"

BusOut Seg1(p12,p13,p14,p15,p16,p17,p18,p19); // A,B,C,D,E,F,G,DP (tens place)
BusOut Seg2(p21,p22,p23,p24,p25,p26,p27,p28); // A,B,C,D,E,F,G,DP (ones place)

void SegInit(void)
{

    Seg1 = SegConvert(0); // initialise to zero
    Seg2 = SegConvert(0); // initialise to zero
}

char SegConvert(int SegValue) // function to convert a number to a 7-segment byte
{
    char SegByte=0x00;
    switch (SegValue) {                // DPGFEDCBA
        case 0 :
            SegByte = 0xC0;
            break; // 00111111 binary
        case 1 :
            SegByte = 0xF9;
            break; // 00000110 binary
        case 2 :
            SegByte = 0xA4;
            break; // 01011011 binary
        case 3 :
            SegByte = 0xB0;
            break; // 01001111 binary
        case 4 :
            SegByte = 0x99;
            break; // 01100110 binary
        case 5 :
            SegByte = 0x92;
            break; // 01101101 binary
        case 6 :
            SegByte = 0x82;
            break; // 01111101 binary
        case 7 :
            SegByte = 0xF8;
            break; // 00000111 binary
        case 8 :
            SegByte = 0x80;
            break; // 01111111 binary
        case 9 :
            SegByte = 0x90;
            break; // 01101111 binary
    }
    return SegByte;
}


