//Cecilia Schneider
//OCE 360 HW #5 October 18,2018

#include "mbed.h"
#define mV_Volt 3300
#define TMP36_calib 500

Serial pc(USBTX, USBRX); //comms to host PC
BusOut Seg1(p12,p13,p14,p15,p16,p17,p18,p19); // A,B,C,D,E,F,G,DP (tens place)
BusOut Seg2(p21,p22,p23,p24,p25,p26,p27,p28); // A,B,C,D,E,F,G,DP (ones place)
AnalogIn TMP36(p20); // temperature sensor input on p20
DigitalIn s1(p11); // switch on p11

char SegConvert(char SegValue); // function to convert a number to a 7-segment byte
float temp = TMP36; // converts analog input to float
int tempmV = (temp*(mV_Volt))-TMP36_calib; // float in volts to int in mV
int tempC = tempmV / 10; // int in mV to degrees C

int main()
{
    while (1) {
        float temp1 = TMP36; //new analog input to float
        int tempmV1 =(temp1*(mV_Volt))-TMP36_calib; // float (V) to int (mV)
        int tempC1 = tempmV1 / 10; // int in mV to degrees C
        int voltdiff = tempmV - tempmV1;
        int tempdiff = tempC - tempC1;
        
        if (s1 == 1){
            int ones = voltdiff % 10; // find the remainder for units column
            int tens = voltdiff / 10; // find the remainder for tens column
            Seg2=SegConvert(abs(ones)); // units column
            Seg1=SegConvert(abs(tens)); // tens column
            // Continuously Output to the Terminal
            pc.printf("Original mV: %d \r\n",tempmV); 
            pc.printf("New mV: %d \r\n",tempmV1); 
            pc.printf("Difference mV: %d \r\n",voltdiff);
            wait(1);
        }
        else {
            int ones = tempdiff % 10; // find the remainder for units column
            int tens = tempdiff / 10; // find the remainder for tens column
            Seg2=SegConvert(abs(ones)); // units column
            Seg1=SegConvert(abs(tens)); // tens column
            // Continuously Output to the Terminal
            pc.printf("Original Temp: %d \r\n",tempC); 
            pc.printf("New Temp: %d \r\n",tempC1); 
            pc.printf("Temp Diff: %d \r\n",tempdiff);
            wait(1);
        }

    }
}
char SegConvert(char SegValue)   // function 'SegConvert'
{
    char SegByte=0x00;
    switch (SegValue) {                // DPGFEDCBA
        case 0 :
            SegByte = 0xC0;
            break; // 00111111 binary
        case 1 :
            SegByte = 0xF9;
            break; // 00000110 binary
        case 2 :
            SegByte = 0xA4;
            break; // 01011011 binary
        case 3 :
            SegByte = 0xB0;
            break; // 01001111 binary
        case 4 :
            SegByte = 0x99;
            break; // 01100110 binary
        case 5 :
            SegByte = 0x92;
            break; // 01101101 binary
        case 6 :
            SegByte = 0x82;
            break; // 01111101 binary
        case 7 :
            SegByte = 0xF8;
            break; // 00000111 binary
        case 8 :
            SegByte = 0x80;
            break; // 01111111 binary
        case 9 :
            SegByte = 0x90;
            break; // 01101111 binary
    }
    return SegByte;
}
