// Craciun Catalin
//  main.h
//   © 2014 Catalin Craciun

#include "mbed.h"
#include "rtos.h"
#include "Buzzer.h"
#include "ZumoRobotManager.h"

using namespace std;

#define RGBLED_ON 0
#define RGBLED_OFF 1

DigitalOut LEDRED(LED_RED);
DigitalOut LEDBLUE(LED_BLUE);
DigitalOut LEDGREEN(LED_GREEN);

//AnalogIn SEN0(PTA5);
//AnalogIn SEN1(PTB2);
DigitalIn SEN2(PTB2);
//AnalogIn SEN3(PTD2); // aici cred ca e conflict cu bluetooth
//AnalogIn SEN4(PTB3);
//AnalogIn SEN5(PTA4);

Buzzer buzzer(PTA12);
ZumoRobotManager zumoRobotManager;

Timer inputTimer;
Serial bluetooth(PTD3, PTD2);

/**
 *  The string received from bluetooth
 */
char bluetoothInput[20];
float velocity;

/**
 *  This method waits for the robot's password in order to unlock it
 */
void waitForPassword();
/**
 *  Method for updating the robot
 */
void update();
/**
 *  Method for initialising the robot
 *  It initialises the bluetooth's baud rate, the leds, creates a new instance of ZumoRobotManager and sets the
 * timer for controlling the bluetooth's transmission flow
 */
void init();

void waitForPassword()
{

    // Turning off the leds
    LEDBLUE = RGBLED_OFF;
    LEDRED = RGBLED_OFF;
    LEDGREEN = RGBLED_OFF;
    while (true) {
        // Waiting to read the password of the bluetooth
        if (bluetooth.readable()) {
            bluetooth.gets(bluetoothInput, 15);

            if (zumoRobotManager.checkPassword(bluetoothInput)) {
                // Sending a "successfuly message" back to the device which sent the password
                bluetooth.printf("$suc");
                break;
            } else {
                // Sending a "failure message" back to the device which sent the password
                bluetooth.printf("$fai");
            }
        }
    }

    update();
}

void update()
{

    // Updating loop

    // Setting the timer for controlling the bluetooth flow
    inputTimer.start();
    Serial pc(USBTX, USBRX);
    // Lighting the green led
    LEDBLUE = RGBLED_OFF;
    LEDRED = RGBLED_OFF;
    LEDGREEN = RGBLED_ON;
    while (true) {
        if (inputTimer.read_ms() >= 10 && bluetooth.readable()) {
            inputTimer.reset();
            bluetooth.gets(bluetoothInput, 15);
            
            bluetooth.printf("Am primit: %s", bluetoothInput);
            
            
            if (bluetoothInput[0] == 'q') {
                zumoRobotManager.setVelocityX(0);
                zumoRobotManager.setVelocityY(0);
                bluetooth.printf("stop\n");
            } else if (bluetoothInput[0] == 'w') {
                zumoRobotManager.setVelocityX(velocity);
                zumoRobotManager.setVelocityY(0);
                bluetooth.printf("inainte\n");
            } else if (bluetoothInput[0] == 's') {
                zumoRobotManager.setVelocityX(-velocity);
                zumoRobotManager.setVelocityY(0);
                bluetooth.printf("inapoi\n");
            } else if (bluetoothInput[0] == 'd') {
                zumoRobotManager.setVelocityX(0);
                zumoRobotManager.setVelocityY(velocity);
                bluetooth.printf("dreapta\n");
            } else if (bluetoothInput[0] == 'a') {
                zumoRobotManager.setVelocityX(0);
                zumoRobotManager.setVelocityY(-velocity);
                bluetooth.printf("stanga\n");
            } else if (bluetoothInput[0] == 'r') {
                bluetooth.printf("Senzor: (%i)\n", SEN2.read());
                //bluetooth.printf("Senzor: (%i, %i, %i, %i, %i, %i)\n", SEN0.read(), SEN1.read(), SEN2.read(), SEN3.read(), SEN4.read(), SEN5.read());
                //bluetooth.printf("Senzor1: (%i, %i, %i, %i, %i, %i)\n", SEN0, SEN1, SEN2, SEN3, SEN4, SEN5); 
            }

            
            // Checking the type of input received
            /*if ((bluetoothInput[0] == '+' || bluetoothInput[0] == '-') &&
                    (bluetoothInput[1] == '+' || bluetoothInput[1] == '-') &&
                    bluetoothInput[2] >= '0' && bluetoothInput[2] <='9' &&
                    bluetoothInput[3] >= '0' && bluetoothInput[3] <='9' &&
                    bluetoothInput[4] >= '0' && bluetoothInput[4] <='9' &&
                    bluetoothInput[5] >= '0' && bluetoothInput[5] <='9') {
                /// Got a "velocity descriptor" string
                velocity = ((bluetoothInput[2] - '0') * 10.0f + (bluetoothInput[3] - '0') * 1.0f) * 0.01f;
                if (bluetoothInput[0] == '-')
                    velocity = -velocity;
                zumoRobotManager.setVelocityX(velocity);

                velocity = ((bluetoothInput[4] - '0') * 10.0f + (bluetoothInput[5] - '0') * 1.0f) * 0.01f;
                if (bluetoothInput[1] == '-')
                    velocity = -velocity;
                zumoRobotManager.setVelocityY(velocity);
            } */
        }
    }

    // Connection was terminated, retrieving the "locked" status
    //waitForPassword();
}

void init()
{

    // Initialising the robot
    velocity = 2;

    // Turning off the leds
    LEDBLUE = RGBLED_OFF;
    LEDRED = RGBLED_OFF;
    LEDGREEN = RGBLED_OFF;

    // Setting the bluetoot's baud rate for communication
    bluetooth.baud(19200);
//    bluetooth.baud(9600);
}

int main()
{

    // Calling init
    init();
    // Locking the robot
    update ();
    //waitForPassword();

    return 0;
}
