#include "CarAPI.h"
#include "Includes/CarBaseAPI.h"

/******************************** Init and Finish ********************************/

void init(){
    _initialize();
}

void finish(){
    _finish();
}

/******************************** Wheels and Motor ********************************/

void turn(float turnAngle){
    turn(0,turnAngle);
}

void move(float power, float seconds){
    move (power,power,seconds);
}

void move(float leftWheelPower,float rightWheelPower, float seconds){
    if(debug) utrace("move(%f,%f,%f)\r\n",leftWheelPower,rightWheelPower,seconds);
    TFC_SetMotorPWM(leftWheelPower,rightWheelPower); // power for n seconds with both wheels the same power
    wait(seconds);
    TFC_SetMotorPWM(0,0); // turn off power to both wheels
    wait(0.05); //need a wait to register or sebsequent calls to this method won't spin the wheel; hardware can't detect instaneous input?    
}

void parkingBrake(){
    if(debug) utrace("parkingBrake()\r\n");
    TFC_SetMotorPWM(0.1,0.1); //slight spinning of wheel
    wait(0.1);
}

void sleep(float seconds){
    if(debug) utrace("sleep(%f)\r\n",seconds);
    wait(seconds);
}


/******************************** INPUTS AND OUTPUTS ********************************/

bool checkIsCrashing(){
    if(debug) utrace("checkIsCrashing()\r\n");
    return abs(accelerometer.getAccX()) >= crashSensitivity;
}

bool isStopped()
{
    double x = accelerometer.getAccX();
    double y = accelerometer.getAccY();
    double z = accelerometer.getAccZ();
    double calAcc = sqrt(x*x + y*y + z*z);
    if (calAcc < stopSensitivity)
        return 1;
    return 0;
}

float lineDirection(){
    return 0;
}

void toggleLED0(){
    if(debug) utrace("toggleLED0()\r\n");
    TFC_BAT_LED0_TOGGLE;    
}

void toggleLED1(){
    if(debug) utrace("toggleLED1()\r\n");
    TFC_BAT_LED1_TOGGLE;    
}

void toggleLED2(){
    if(debug) utrace("toggleLED2()\r\n");
    TFC_BAT_LED2_TOGGLE;    
}

void toggleLED3(){
    if(debug) utrace("toggleLED3()\r\n");
    TFC_BAT_LED3_TOGGLE;    
}

bool isButtonBPressed(){
    if(debug) utrace("isButtonBPressed()=%d\r\n",TFC_PUSH_BUTTON_1_PRESSED);
    return TFC_PUSH_BUTTON_1_PRESSED;
}

float getPot0(){
    if(debug) utrace("getPot0()= %f\r\n", TFC_ReadPot(0));
    return TFC_ReadPot(0);
}

float getPot1(){
    if(debug) utrace("getPot1()= %f\r\n", TFC_ReadPot(1));
    return TFC_ReadPot(1);
}

float batteryLife(){
    if(debug) utrace("batteryLife()= %f\r\n", TFC_ReadBatteryVoltage());
    return TFC_ReadBatteryVoltage();
}

/******************************** Changing Variables ********************************/

void setOffset(float _turnOffset){
    if(debug) utrace("setOffset(%f)\r\n", _turnOffset);
    turnOffset = _turnOffset;
}

float getOffset(){
    if(debug) utrace("getOffset()= %f\r\n", turnOffset);
    return turnOffset;
}

void setCrashSensitivity(float _sensitivity){
    if(debug) utrace("setCrashSensitivity(%f)\r\n", _sensitivity);
    crashSensitivity = _sensitivity;
}

float getCrashSensitivity(){
    if(debug) utrace("getCrashSensitivity()= %f\r\n", crashSensitivity);
    return crashSensitivity;
}

void setStopSensitivity(float _sensitivity){
    if(debug) utrace("setStopSensitivity(%f)\r\n", _sensitivity);
    stopSensitivity = _sensitivity;
}

float getStopSensitivity(){
    if(debug) utrace("getStopSensitivity()= %f\r\n", stopSensitivity);
    return stopSensitivity;
}

void setDebug(bool _debug){
    if(debug) utrace("setDebug()= %d\r\n", _debug);
    debug = _debug;
}