/**
 * @defgroup FRDM-UTCS-CAR_API FRDM-UTCS-CAR_API
 *
 * @{
 */


/**

@addtogroup FRDM-UTCS-CAR_API

@{
*/

#ifndef CAR_API_0yx22l34755
#define CAR_API_0yx22l34755

/******************************** Init and Finish ********************************/
void init();

void finish();

/******************************** Wheels and Motor ********************************/

/** Turn the car.  
  * @param turnAngle value between [-1,1]. Negative indicates turning left, and
  *        positive indicates turning right.
  */
void turn(float turnAngle);

/** Move forward with the given power for a specified time.
  * @param power Value between [-1, 1]. Negative indicates reverse, positive indicates forward motion.
  * @param seconds Amount of time in seconds which the wheels will rotate at the given power.
  */
void move(float power, float seconds);

/** Move forward with the given powers for each wheel for a specified time.
  * @param leftWheelPower Value between [-1, 1]. Negative values indicate left wheel will rotate backward,
  *        positive values indicate left wheel will rotate forward. More positive and more negative indicate 
  *        more power in the indicated directions.
  * @param rightWheelPower Value between [-1, 1]. Negative values indicate right wheel will rotate backward,
  *        positive values indicate right wheel will rotate forward. More positive and more negative indicate 
  *        more power in the indicated directions.
  * @param seconds Amount of time in seconds the wheels will rotate at the given powers.
  */
void move(float leftWheelPower, float rightWheelPower,  float seconds);

/** Lock the wheels. */
void parkingBrake();

/** Do nothing for the specified time.
  * @param seconds Number of seconds to do nothing.
  */
void sleep(float seconds);

/******************************** INPUTS AND OUTPUTS ********************************/

/** Check to see if the car is crashing into something.
  * @return True if car is coming to an abrupt halt, else false.
  */
bool checkIsCrashing();

/** Get the line direction with respect to the car.
 *  @return Floating point number. [-1,0) if line is to the left of center,
 *          (0,1] if the line is to the right of center,
 *          or zero (0) if line is in the center.
 */
float lineDirection();

/* Toggle LED 0. */
void toggleLED0();

/* Toggle LED 1. */
void toggleLED1();

/* Toggle LED 2. */
void toggleLED2();

/* Toggle LED 3. */
void toggleLED3();

/** Check if Button B was pressed. */
bool isButtonBPressed();

/** Read Potentiometer 0.
  * @return Value between [-1,1]. */
float getPot0();

/** Read Potentiometer 1.
  * @return Value between [-1,1]. */
float getPot1();

/** Get remaining battery charge.
  * @return Value between [0,1]. */
float batteryLife();

/******************************** Changing Variables ********************************/
/** Set the base turn offset to compensate for imperfect hardware configuration.
  * @param _turnOffset New value for servo turn offset. Accepted values between [-0.7, 0.7].
  */
void setOffset(float _turnOffset);

/** Get the current value of the servo turn offset.
  * @return Value of the current servo turn offset, between [-0.7, 0.7].
  */
float getOffset();

/** Set the base crash sensitivity. 
  * @param _sensitivity Value to be set as the new crash sensitivity. Accepted values between 
  *        [0, 1]. A higher value indicates lower sensitivity, and a lower value indicates higher 
  *        sensitivity.
  */
void setCrashSensitivity(float _sensitivity);

/** Return the crash sensitivity.
  * @return Value of the current crash sensitivity, between [-1, 1]. A higher value indicates 
  *         lower sensitivity, and a lower value indicates higher sensitivity.
  */
float getCrashSensitivity();

/** Turn on debugging. Prints each method call to the serial port.
  * @param _debug True to turn on debugging, false to turn it off.
  */
void setDebug(bool _debug);


#endif