#ifndef CAR_BASE_API_046o73i4277823
#define CAR_BASE_API_046o73i4277823

#include <stdarg.h>
#include <MMA8451Q.h>
#include "TFC.h"

Ticker TFC_TickerObj;
Serial pc(USBTX,USBRX);
// AnalogIn pot (p15);

#define NUM_TFC_TICKERS 4
#define MMA8451_I2C_ADDRESS (0x1d<<1)
// Define serial ports
volatile uint32_t TFC_Ticker[NUM_TFC_TICKERS];


float turnOffset = 0.0;// the turn turnOffset
float crashSensitivity = 0.5; // crash sensitivity
float stopSensitivity = 0.2; // stop sensitivity
bool debug = false;

MMA8451Q accelerometer(PTE25,PTE24, MMA8451_I2C_ADDRESS);

void TFC_TickerUpdate()
{
    int i;
    for(i=0; i<NUM_TFC_TICKERS; i++)
    {
        if(TFC_Ticker[i]<0xFFFFFFFF)
        {
           TFC_Ticker[0]++;
        }
    }
}

void utrace(const char* msg, ...){
    char buffer[256];
    va_list args;
    va_start (args, msg);
    vsprintf (buffer,msg, args);
    va_end (args);
    pc.printf(buffer);
}

void flushSerialBuffer(void) { while (pc.readable()) { pc.getc(); } return; } 

void _blinkSequence(bool left){
    static float w = 0.125;
    if (left) {
        if (TFC_PUSH_BUTTON_0_PRESSED) return;
        TFC_BAT_LED0_TOGGLE;
        wait(w);
        TFC_BAT_LED0_TOGGLE;
        if (TFC_PUSH_BUTTON_0_PRESSED) return;
        TFC_BAT_LED1_TOGGLE;
        wait(w);
        TFC_BAT_LED1_TOGGLE;
        if (TFC_PUSH_BUTTON_0_PRESSED) return;
        TFC_BAT_LED2_TOGGLE;
        wait(w);
        TFC_BAT_LED2_TOGGLE;
        if (TFC_PUSH_BUTTON_0_PRESSED) return;
        TFC_BAT_LED3_TOGGLE;    
        wait(w);
        TFC_BAT_LED3_TOGGLE;    
    } else {
        if (TFC_PUSH_BUTTON_0_PRESSED) return;
        TFC_BAT_LED3_TOGGLE;
        wait(w);
        TFC_BAT_LED3_TOGGLE;
        if (TFC_PUSH_BUTTON_0_PRESSED) return;
        TFC_BAT_LED2_TOGGLE;
        wait(w);
        TFC_BAT_LED2_TOGGLE;
        if (TFC_PUSH_BUTTON_0_PRESSED) return;
        TFC_BAT_LED1_TOGGLE;
        wait(w);
        TFC_BAT_LED1_TOGGLE;
        if (TFC_PUSH_BUTTON_0_PRESSED) return;
        TFC_BAT_LED0_TOGGLE;
        wait(w);            
        TFC_BAT_LED0_TOGGLE;
    }
}

void blinkSequence(){
    _blinkSequence(false);
    _blinkSequence(true);
}

void blinkSequence2(){
    float w = 0.125;
    TFC_BAT_LED0_TOGGLE;
    if (TFC_PUSH_BUTTON_0_PRESSED) return;
    wait(w);
    TFC_BAT_LED1_TOGGLE;
    if (TFC_PUSH_BUTTON_0_PRESSED) return;
    wait(w);
    TFC_BAT_LED2_TOGGLE;
    if (TFC_PUSH_BUTTON_0_PRESSED) return;
    wait(w);
    TFC_BAT_LED3_TOGGLE;
    if (TFC_PUSH_BUTTON_0_PRESSED) return;
    wait(w);
    TFC_BAT_LED3_TOGGLE;
    if (TFC_PUSH_BUTTON_0_PRESSED) return;
    wait(w);
    TFC_BAT_LED2_TOGGLE;
    if (TFC_PUSH_BUTTON_0_PRESSED) return;
    wait(w);
    TFC_BAT_LED1_TOGGLE;
    if (TFC_PUSH_BUTTON_0_PRESSED) return;
    wait(w);
    TFC_BAT_LED0_TOGGLE;
    if (TFC_PUSH_BUTTON_0_PRESSED) return;
    wait(w);    
}
/* turn the car */
void turn(float d, float turnAngle){
    if (turnAngle >0.7)
        turnAngle = 0.7;
    else if (turnAngle < -0.7)
        turnAngle = -0.7;
    if(debug) utrace("turn(%f)\r\n",turnAngle);
    TFC_SetServo(d,turnAngle + turnOffset);
}

void _initialize(){
    if(debug) utrace("initialize()\r\n");
    //TFC_TickerObj.attach_us(&TFC_TickerUpdate,1000);   //Things go to heck if this is enabled
    TFC_Init();
    
    // init servo position to 0
    TFC_SetServo(0, 0);

    // Initialize Baud Rate for PC Console
    pc.baud(38400);

    //flash startup
    while(!TFC_PUSH_BUTTON_0_PRESSED){
        blinkSequence();
    }
    wait(0.75);
    //starts power to back motor - hear high frequency pitch
    TFC_HBRIDGE_ENABLE;    
}

void _finish(){
    //parking brake
    //need to keep spinning wheel slightly or the car will come crashing down backwards the ramp b/c of gravity
    //slight spin is not enough to move the car (even on flat surface)
    //press button 0 to stop parking brake and turn off motor - goes into wait period w/ LED1 blinking
    while (!TFC_PUSH_BUTTON_0_PRESSED){
        /// sharon's parking break code
        TFC_SetMotorPWM(0.1,0.1); //slight spinning of wheel
        blinkSequence2();
    }
    
    // reset servo position to 0
    TFC_SetServo(0, 0);

    //reset to straight direction and stop spinning motor
    TFC_SetMotorPWM(0,0);
    
    //stops the power to back motor - stop hearing the high pitch frequency
    TFC_HBRIDGE_DISABLE;
    if(debug) utrace("finish()\r\n");
}


#endif