/**
README: The Lottery toy that used in LASS(http://lass-net.org/) Users and Developers conference 2016.
    Each run will generate GIFT_MAXCNT non-repeat number, random range ( 1 to MAN_MAXCNT )
Hardware: mbed LPC1768 + mbed Application Board
*/
#include "mbed.h"
#include "C12832.h"


C12832 lcd(p5, p7, p6, p8, p11);
DigitalIn fire(p14);

BusOut leds(LED1,LED2,LED3,LED4);
AnalogIn RandomIn(p17); // use the random noise on this analog input to seed the random generator
#define GIFT_MAXCNT 24 // Max gift count 
#define MAN_MAXCNT 120 // How many users 


void SetLed(uint8_t ledID, bool on)
{
    if (ledID <= 6) {
        if (on)
            leds = leds | (0x01 << ledID);
        else
            leds = leds & ~(0x01 << ledID);
    }
}

void SweepAllLeds(bool leftToRight, float delay)
{
    leds=0;
    wait(delay);
    for(int n=0; n<4; n++) {
        rand();
        SetLed(leftToRight?n:4-n, true);
        wait(delay); // delay
    }
}

int main()
{
    int gift[GIFT_MAXCNT];
    int item[MAN_MAXCNT];

    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("LASS Conference");
    lcd.locate(0,15);
    lcd.printf("Lottery 1-120");
    while (!fire) { // After botton pressed, generate random seed
        SweepAllLeds(true,0.01);
        uint32_t seedValue = 0;
        uint16_t value;
        uint8_t counter;

        for (counter = 0; counter < 32; counter++) {
            seedValue = seedValue<<1;
            value = RandomIn.read_u16(); // reads a 10 bit ADC normalised to 16 bits.
            if (value & 0x0040)          // LSB of ADC output is a 1
                seedValue++;
        }
        srand(seedValue);
    }

    // show some UI to feel like Lottery
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Begin Lottery...");
    SweepAllLeds(true,0.1);
    SweepAllLeds(true,0.1);
    SweepAllLeds(true,0.1);
    SweepAllLeds(true,0.1);
    float twait=(rand()%10)/10;
    wait(twait);
    lcd.locate(0,3);
    lcd.cls();
    
    // Generate non-repeat users 
    for(int i=0;i<MAN_MAXCNT;i++){
        item[i] = i;
    }
    for(int i=0;i<GIFT_MAXCNT;i++){
        int rand_num = rand()%(MAN_MAXCNT-i);
        gift[i] = item[rand_num] + 1;
        if (rand_num != MAN_MAXCNT-i-1) {
            item[rand_num] = item[MAN_MAXCNT-i-1];
        }
    }

    // Show the results on LCD
    for(int i=0;i<GIFT_MAXCNT;i++){
        int x=(i % 8)*16;
        int y = int(i/8)*10;
        lcd.locate(x,y);
        lcd.printf("%3d", gift[i]);
    }

}
