/*  Cosmic Ray Sheilding 
    Date Created: Spring Semester 2019

    Program to detect number of Geiger Counter hits and read data to SDcard
    The time since program start and the voltage 
    are written to a tab-delimited data file. 
    SD pins: DI = p5, DO = p6, SCK = p7, CS = p8  
*/ 

#include "mbed.h" 
#include "SDFileSystem.h" 
#include "ExtendedTimer.h"

InterruptIn geigerDelrin(p14); //Counter Serial Number Ending in:101
InterruptIn geigerJello(p13); //Counter Serial Number Ending in:142
Serial pc (USBTX, USBRX);
SDFileSystem fs(p5, p6, p7, p8, "fs");
DigitalOut doneLED(LED1); 

ExtendedTimer t;
Ticker sampleTime;
Ticker saveTime;

void countDelrinPulse(void); //Function called when Delrin Geiger reads pulse
void countJelloPulse(void); //Function called when Jello Geiger reads pulse

int jelloCount = 0;
int delrinCount = 0;
bool timeToSample;
bool timeToSave;

    void triggerSample() {
        timeToSave = true; // flag to save data
    }
 
    void triggerCollection() {
        timeToSample = true; // flag to collect data
    }

int main(){     
    //Geiger Counter Interrupts
    geigerDelrin.fall(&countDelrinPulse); 
    geigerJello.fall(&countJelloPulse);
    
    // Mount the filesystem 
    bool mountFailure = fs.mount(); 

    if (mountFailure != 0) { 
        pc.printf("Failed to mount the SD card.\r\n"); 
        return -1;  // ends program with error status 
    } 
    FILE* fp = fopen("/fs/log.txt","w"); 
    if (fp == NULL) { 
        pc.printf("Failed to open the file.\r\n"); 
        fs.unmount(); 
        return -1; 
    } 

    // Data header 
    pc.printf("Time (s) \t Jello Count \t Delrin Count \r\n"); 
    fprintf(fp, "Time (s) \t Jello Count \t Delrin Count \r\n");
    
    // Attach ISR(s) to tickers
    sampleTime.attach(&triggerSample, 10); //Sample every 60 seconds
    saveTime.attach(&triggerCollection, 30); //Save data every 5 minutes.
    
    timeToSample = true;
    timeToSave = false;
    
    // Start the timer and ticker 
    t.start();

    while (t.read() < 18000) {    
        if (timeToSample){ //Displays number of counts per 60 seconds
            timeToSample = false;
            pc.printf("%.2f \t\t %d \t\t %d \r\n",t.read(), jelloCount, delrinCount);
            fprintf(fp, "%.2f \t\t %d \t\t %d \r\n",t.read(), jelloCount, delrinCount);
            jelloCount = 0;
            delrinCount = 0;
        }
        
        if (timeToSave){ //Data will save every five minutes
            timeToSave = false;
            fclose(fp);
            fp = fopen("/fs/log.txt","a");
        }
    }
    
    // Close file and unmount the file system 
    fclose(fp); 
    
    fs.unmount(); 
    // LED on indicates that it is safe to remove the SD card 
    doneLED = 1; 
} 

//Incrementation of counts 
void countDelrinPulse(void){
    delrinCount++;
}

void countJelloPulse(void){
    jelloCount++;
}