/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "N5110.h"

#include "shapes.h"
#include "main.h"
#include "monster.h"

N5110 lcd(p8,p9,p10,p11,p13,p21);
DigitalIn button_A(p29);
DigitalIn button_B(p28);
DigitalIn button_C(p27);
DigitalIn button_D(p26);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

Monster monster;

int lifes;
int score, best_score;
bool auto_attack;

void init();
void welcome();

void choice();

void game_begin();
void show_score();
void instruction();

int main()
{
    init();
    welcome();
    
    while(1) {
        
        if (button_A.read() == 1 ) {
        
            choice();
             
        }
    }
    
}

//**********************//

void init() {
    
    lcd.init();
    lifes = 3;
    score = 0;
    
}

void welcome() {
    
    lcd.clear();
    
    lcd.drawSprite(60,12,12,14,(int *)bigMonster);
    lcd.printString("Monster",0,0);
    lcd.printString("Game",0,2);
    
    lcd.printString("Press A  NEXT",0,5);
    
    lcd.refresh();
    thread_sleep_for(50);
    
}

void choice() {

    lcd.clear();
    
    lcd.printString("A. BEGIN",0,0);
    lcd.printString("B. SCORE",0,2);
    lcd.printString("C. INFO",0,4);
    
    lcd.refresh();
    
    thread_sleep_for(50);
    
    while(1) {
        
        if(button_A.read() == 1) {
              game_begin();
        }
        if(button_B.read() == 1) {
              show_score();
        }
        if(button_C.read() == 1) {
              instruction();
        }
        if(button_D.read() == 1) {
              
            lcd.clear();
            
            lcd.printString("THE LAST",18,2);
            lcd.printString("DEFENCE",21,4);
            
            lcd.refresh();
            
            thread_sleep_for(200);
              
            monster.monster_main3(lcd, button_A, button_B, button_C, button_D, led1, led2, led3);
        }
           
    }
   
}

//***********************//

void game_begin() {
    
    monster.monster_main(lcd, button_A, button_B, button_C, button_D, led1, led2, led3);
    
}

void show_score() {
    
    lcd.clear();
    
    lcd.printString("BEST SCORE",12,1);
    
    char buffer[14];
    sprintf(buffer,"%d",best_score);
    lcd.printString(buffer,12,3);
    
    lcd.printString("Press A   BACK",0,5);
    
    lcd.refresh();
    
    while(1) {
     
        if(button_A.read() == 1) {
            choice();
        }    
    }
    
}


void instruction() {
    
    lcd.clear();
    
    lcd.drawSprite(0,0,6,7,(int *)whiteMonster);
    lcd.drawSprite(0,9,7,7,(int *)blackMonster);
    lcd.drawSprite(2,19,3,3,(int *)shapStar);
    lcd.drawSprite(1,26,4,5,(int *)shapHeart);
    
    lcd.printString("Your monster",12,0);
    lcd.printString("Enemy",12,1);
    lcd.printString("Jewel",12,2);
    lcd.printString("Lives",12,3);
    
    lcd.printString("Press A   BACK",0,5);
    
    // thread_sleep_for(200);
    lcd.refresh();
    
    while(1) {
     
        if(button_A.read() == 1) {
            choice();
        }    
    }
    
}
