#include "monster.h"
#include "cstdlib"
#include "ctime"
#include "vector"

using namespace std;

#define random(a,b) (rand()%(b-a)+a)

AnalogIn  joy_v(p20);
AnalogIn  joy_h(p19);
InterruptIn joy_button(p17);

volatile int joy_button_flag = 0;

int level = 1;
int score_temp;

int time_count;
bool fire = true;

//第三关
struct Bullets {
    
    int x;
    int y;
    
};

Bullets buls;
int add_bullets = 1;
vector<Bullets> bullets;

//敌方子弹
struct BlackBullets {
    
    int x;
    int y;
    
};

BlackBullets black_buls;
vector<BlackBullets> black_bullets;

struct Monster_A {
    
    int x;
    int y;
    
};

struct Monster_B {
    
    int x;
    int y;
    int lives = 2;
    
};

struct Monster_C {
    
    int x;
    int y;
    int lives = 5;
    
};

Monster_A m_a;
vector<Monster_A> monster_a;

Monster_B m_b;
vector<Monster_B> monster_b;

Monster_C m_c;
vector<Monster_C> monster_c;

bool add_monster = true;

void joy_button_isr();

Monster::Monster() {}

void Monster::monster_main(N5110 &lcd, DigitalIn &button_A, DigitalIn &button_B, DigitalIn &button_C, DigitalIn &button_D,
                           DigitalOut led1, DigitalOut led2, DigitalOut led3) {
                               
    joy_button.fall(&joy_button_isr);
    joy_button.mode(PullDown);    
    
    switch (level) {
        
        case 1:
              this->monster_main1(lcd, button_A, button_B, button_C, button_D, led1, led2, led3);
              break;     
        case 2:
              this->monster_main2(lcd, button_A, button_B, button_C, button_D, led1, led2, led3);
              break;
        case 3:
              this->monster_main3(lcd, button_A, button_B, button_C, button_D, led1, led2, led3);
              break;
    }
    
}

//第一关
void Monster::monster_main1(N5110 &lcd, DigitalIn &button_A, DigitalIn &button_B, DigitalIn &button_C, DigitalIn &button_D,
                           DigitalOut led1, DigitalOut led2, DigitalOut led3) {
    //初始化暂停键
    joy_button_flag = 0;
    
    //设置人物初始位置
    monster_x0 = 4;
    monster_y0 = 19;
    
    //设置反派位置
    monster_x1 = 23;
    monster_y1 = 19;
    turn1 = 0;
    
    monster_x2 = 18;
    monster_y2 = 37;
    turn2 = 0;
    
    monster_x3 = 68;
    monster_y3 = 37;
    turn3 = 0;
    
    //开启宝石
    int temp_jewels_x[7] = {41,46,2,7,12,38,43};
    int temp_jewels_y[7] = {21,21,39,39,39,36,36};
    
    for (int i=0; i<7; i++) {
        jewels_on[i] = 1;
        jewels_x[i] = temp_jewels_x[i];
        jewels_y[i] = temp_jewels_y[i];
    }
    
    while(1) {
        
        lcd.clear();
        
        //画完背景和生命，移动人物，判断是否有障碍物
        
        //画背景
        this->drawbackground1(lcd);
        this->drawscores(lcd);
        
        //画人物
        this->draw_monster(lcd, button_A, button_B, button_C, button_D);
        
        //画宝石和反派
        this->draw_jewels(lcd);
        this->draw_blackmonsters1(lcd);
        
        //失去生命
        this->loss_life(lcd);
        
        //画生命
        this->drawlifes(lcd, led1, led2, led3);
        
        lcd.refresh();
        
        if (monster_x0 >84) {
            score_temp = score;
            level = 2;
            this->monster_main2(lcd, button_A, button_B, button_C, button_D, led1, led2, led3);   
        }
        
        if (lifes <= 0) {
            break;
        }
        
        //暂停
        if (joy_button_flag == 1) {
            
            this->pause(lcd,button_A,button_B);
            
        }
    
        thread_sleep_for(15); 
    }
    
    //游戏结束
    this->game_over(lcd,button_A);
    
}

//第二关
void Monster::monster_main2(N5110 &lcd, DigitalIn &button_A, DigitalIn &button_B, DigitalIn &button_C, DigitalIn &button_D,
                           DigitalOut led1, DigitalOut led2, DigitalOut led3) {
    //设置人物初始位置
    monster_x0 = 0;
    
    //设置反派位置
    monster_x1 = 25;
    monster_y1 = 11;
    turn1 = 0;
    
    monster_x2 = 49;
    monster_y2 = 30;
    turn2 = 0;
    
    monster_x3 = 71;
    monster_y3 = 17;
    turn3 = 0;
    
    //开启宝石
    int temp_jewels_x[7] = {6,11,42,47,52,42,74};
    int temp_jewels_y[7] = {39,39,11,11,11,32,32};
    
    for (int i=0; i<7; i++) {
        jewels_on[i] = 1;
        jewels_x[i] = temp_jewels_x[i];
        jewels_y[i] = temp_jewels_y[i];
    }
    
    while(1) {
        
        lcd.clear();
        
        //画完背景和生命，移动人物，判断是否有障碍物
        
        //画背景
        this->drawbackground2(lcd);
        this->drawscores(lcd);
        
        //画人物
        this->draw_monster(lcd, button_A, button_B, button_C, button_D);
        
        //画宝石和反派
        this->draw_jewels(lcd);
        this->draw_blackmonsters2(lcd);
        
        //失去生命
        this->loss_life(lcd);
        
        //画生命
        this->drawlifes(lcd, led1, led2, led3);
        
        lcd.refresh();
        
        if (monster_x0 >84) {
            this->continueFight(lcd, button_A, button_B, button_C, button_D, led1, led2, led3);  
        }
        
        if (lifes <= 0) {
            break;
        }
        
        //暂停
        if (joy_button_flag == 1) {
            
            this->pause(lcd,button_A,button_B);
            
        }
    
        thread_sleep_for(15); 
    }
    
    //游戏结束
    this->game_over(lcd,button_A);
    
}

//画背景1
void Monster::drawbackground1(N5110 &lcd) {
    
    lcd.drawLine(0,8,84,8,2);
    lcd.drawRect(23,26,26,4,FILL_BLACK);
    lcd.drawRect(0,44,84,4,FILL_BLACK);
    lcd.drawRect(28,40,26,4,FILL_BLACK);
    lcd.drawRect(67,22,17,11,FILL_TRANSPARENT);
       
}

//画背景2
void Monster::drawbackground2(N5110 &lcd) {
    
    lcd.drawLine(0,8,84,8,2);
    lcd.drawLine(12,9,72,9,1);
    lcd.drawRect(29,25,26,4,FILL_BLACK);
    lcd.drawRect(29,38,26,2,FILL_BLACK);
    lcd.drawRect(82,25,2,23,FILL_BLACK);
    lcd.drawRect(0,44,17,4,FILL_BLACK);
    lcd.drawRect(0,22,17,11,FILL_TRANSPARENT);
}

//画生命
void Monster::drawlifes(N5110 &lcd, DigitalOut led1, DigitalOut led2, DigitalOut led3) {
    
    for(int i=1; i<=lifes; i++) {
        
        lcd.drawSprite(7*i-4,2,4,5,(int *)shapHeart);
        
    }
    switch (lifes) {
     case 3:
        led1 = 1;
        led2 = 1;
        led3 = 1;
        break;
        
    case 2: 
        led1 = 1;
        led2 = 1;
        led3 = 0;
        break;
        
    case 1: 
        led1 = 1;
        led2 = 0;
        led3 = 0;
        break;
        
    default:
        led1 = 0;
        led2 = 0;
        led3 = 0;
        break;
    }
    
}

void Monster::drawscores(N5110 &lcd) {
    
    char score_buffer[14];
    sprintf(score_buffer,"%d",score);
    lcd.printString(score_buffer,60,0);
    
}

//画反派 关卡1
void Monster::draw_blackmonsters1(N5110 &lcd) {
    
    
    //画反派1
    if (turn1 == 0) {
        
        monster_x1 += 1;
        lcd.drawSprite(monster_x1,monster_y1,7,7,(int *)blackMonster);
        
        if (monster_x1 >= 43) {
           turn1 = 1;
        }
           
    }
    
    if (turn1 == 1) {
        
        monster_x1 -= 1;
        lcd.drawSprite(monster_x1,monster_y1,7,7,(int *)blackMonster);
        
        if (monster_x1 <= 23) {
           turn1 = 0;
        }
           
    }
    
    //画反派2
    if (turn2 == 0) {
        
        monster_x2 += 1;
        lcd.drawSprite(monster_x2,monster_y2,7,7,(int *)blackMonster);
        
        if (monster_x2 >= 20) {
           turn2 = 1;
        }
           
    }
    
    if (turn2 == 1) {
        
        monster_x2 -= 1;
        lcd.drawSprite(monster_x2,monster_y2,7,7,(int *)blackMonster);
        
        if (monster_x2 <= 1) {
           turn2 = 0;
        }
           
    }
    
    //画反派3
    if (turn3 == 0) {
        
        monster_x3 += 1;
        lcd.drawSprite(monster_x3,monster_y3,7,7,(int *)blackMonster);
        
        if (monster_x3 >= 75) {
           turn3 = 1;
        }
           
    }
    
    if (turn3 == 1) {
        
        monster_x3 -= 1;
        lcd.drawSprite(monster_x3,monster_y3,7,7,(int *)blackMonster);
        
        if (monster_x3 <= 56) {
           turn3 = 0;
        }
           
    }
    
}

//画反派 关卡2
void Monster::draw_blackmonsters2(N5110 &lcd) {
    
    
    //画反派1
    if (turn1 == 0) {
        
        monster_x1 += 1;
        lcd.drawSprite(monster_x1,monster_y1,7,7,(int *)blackAntiMonster);
        
        if (monster_x1 >= 65) {
           turn1 = 1;
        }
           
    }
    
    if (turn1 == 1) {
        
        monster_x1 -= 1;
        lcd.drawSprite(monster_x1,monster_y1,7,7,(int *)blackAntiMonster);
        
        if (monster_x1 <= 12) {
           turn1 = 0;
        }
           
    }
    
    //画反派2
    if (turn2 == 0) {
        
        monster_x2 += 1;
        lcd.drawSprite(monster_x2,monster_y2,7,7,(int *)blackAntiMonster);
        
        if (monster_x2 >= 48) {
           turn2 = 1;
        }
           
    }
    
    if (turn2 == 1) {
        
        monster_x2 -= 1;
        lcd.drawSprite(monster_x2,monster_y2,7,7,(int *)blackAntiMonster);
        
        if (monster_x2 <= 29) {
           turn2 = 0;
        }
           
    }
    
    //画反派3
    if (turn3 == 0) {
        
        monster_y3 += 1;
        lcd.drawSprite(monster_x3,monster_y3,7,7,(int *)blackMonster);
        
        if (monster_y3 >= 40) {
           turn3 = 1;
        }
           
    }
    
    if (turn3 == 1) {
        
        monster_y3 -= 1;
        lcd.drawSprite(monster_x3,monster_y3,7,7,(int *)blackMonster);
        
        if (monster_y3 <= 17) {
           turn3 = 0;
        }
           
    }
    
}

//画宝石
void Monster::draw_jewels(N5110 &lcd) {
    
    for (int i=0; i<7; i++) {
        
        if (jewels_on[i] == 1) {
             lcd.drawSprite(jewels_x[i],jewels_y[i],3,3,(int *)shapStar);
        }
          
    }
       
}

//画人物
void Monster::draw_monster(N5110 &lcd, DigitalIn &button_A, DigitalIn &button_B, DigitalIn &button_C, DigitalIn &button_D) {
    
    if (button_A.read() == 1 && lcd.getPixel(monster_x0+8,monster_y0) == 0 && lcd.getPixel(monster_x0+8,monster_y0+3) == 0 && lcd.getPixel(monster_x0+8,monster_y0+5) == 0) {
        monster_x0 += 1;  
    }
    else if (button_B.read() == 1 && lcd.getPixel(monster_x0,monster_y0-1) == 0 && lcd.getPixel(monster_x0+7,monster_y0-1) == 0) {
        monster_y0 -= 1;  
    }
    else if (button_C.read() == 1 && lcd.getPixel(monster_x0-1,monster_y0) == 0 && lcd.getPixel(monster_x0-1,monster_y0+3) == 0 && lcd.getPixel(monster_x0-1,monster_y0+5) == 0) {
        monster_x0 -= 1;  
    }
    else if (button_D.read() == 1 && lcd.getPixel(monster_x0,monster_y0+6) == 0 && lcd.getPixel(monster_x0+7,monster_y0+6) == 0) {
        monster_y0 += 1;  
    }
    else if (joy_h.read() < 0.25 && lcd.getPixel(monster_x0+8,monster_y0) == 0 && lcd.getPixel(monster_x0+8,monster_y0+3) == 0 && lcd.getPixel(monster_x0+8,monster_y0+5) == 0) {
        monster_x0 += 1;  
    }
    else if (joy_v.read() > 0.75 && lcd.getPixel(monster_x0,monster_y0-1) == 0 && lcd.getPixel(monster_x0+7,monster_y0-1) == 0) {
        monster_y0 -= 1;  
    }
    else if (joy_h.read() > 0.85 && lcd.getPixel(monster_x0-1,monster_y0) == 0 && lcd.getPixel(monster_x0-1,monster_y0+3) == 0 && lcd.getPixel(monster_x0-1,monster_y0+5) == 0) {
        monster_x0 -= 1;  
    }
    else if (joy_v.read() < 0.3 && lcd.getPixel(monster_x0,monster_y0+6) == 0 && lcd.getPixel(monster_x0+7,monster_y0+6) == 0) {
        monster_y0 += 1;  
    }
    
    //向左限定
    if (monster_x0 < 0) {
       monster_x0 = 0;
    }
    //向上限定
    if (monster_y0 < 9) {
       monster_y0 = 9;
    }
    //向下限定
    if (monster_y0 > 41) {
        monster_y0 = 41;   
    }
    
    lcd.drawSprite(monster_x0,monster_y0,6,7,(int *)whiteMonster);
    
    //是否碰到宝石
    for (int i=0; i<7; i++) {
        if (abs(monster_x0-jewels_x[i]+2) <= 4 && abs(monster_y0-jewels_y[i]+2) <= 4) {
            score += 1;
            jewels_x[i] = 100;
            jewels_y[i] = 100;   
        }
    }   
}
//失去生命
void Monster::loss_life(N5110 &lcd) {
    
    if (abs(monster_x0-monster_x1) < 7 && abs(monster_y0-monster_y1) < 6) {
        lifes -= 1;
        //turn1 = 0;
        monster_x1 = 100;
        monster_y1 = 100;
        thread_sleep_for(100);
    }
    else if (abs(monster_x0-monster_x2) < 7 && abs(monster_y0-monster_y2) < 6) {
        lifes -= 1;
        //turn1 = 0;
        monster_x2 = 100;
        monster_y2 = 100;
        thread_sleep_for(100);
    }
    else if (abs(monster_x0-monster_x3) < 7 && abs(monster_y0-monster_y3) < 6) {
        lifes -= 1;
        //turn1 = 0;
        monster_x3 = 100;
        monster_y3 = 100;
        thread_sleep_for(100);
    }
}

//游戏结束
void Monster::game_over(N5110 &lcd, DigitalIn &button_A) {
    
    level = 1;
    score_temp = 0;
    
    //最高分数
    if (score > best_score) {
        best_score = score;
    }
    
    //结束界面
    thread_sleep_for(100);
    lcd.clear();
    lcd.printString("GAME OVER",16,1);
    lcd.printString("PRESS A    OUT",0,5);
    lcd.refresh();
    
    while (button_A == 0) {
        
    }
    main();
       
}

//暂停游戏
void Monster::pause(N5110 &lcd, DigitalIn &button_A, DigitalIn &button_B) {
    
    joy_button_flag = 0;
    
    while(1) {
        
        lcd.clear();
    
        lcd.printString("PAUSE",28,1);
        lcd.drawLine(0,30,84,30,2);
        lcd.printString("A.    CONTINUE",0,4);
        lcd.printString("B.         OUT",0,5);
        
        lcd.refresh();
        
        if (button_A.read() == 1) {
            break;   
        }
        else if (button_B.read() == 1) {
            
            //最高分数
            if (score > best_score) {
                best_score = score;
            }
            
            score = score_temp;
            
            choice();
        }
    
    }
}

void joy_button_isr() {
 
    joy_button_flag = 1;
    
}

//隐藏关卡的开启
void Monster::continueFight(N5110 &lcd, DigitalIn &button_A, DigitalIn &button_B, DigitalIn &button_C, DigitalIn &button_D,
            DigitalOut led1, DigitalOut led2, DigitalOut led3) {
    
    lcd.clear();
    
    lcd.printString("CONGRATULATE!",3,0);
    lcd.printString("YOU WIN",21,2);
    lcd.printString("PRESS A    OUT",0,5);
    
    lcd.refresh();
    
    thread_sleep_for(50);
    
    while(1) {
        
        if (button_A.read() == 1) {
            
            level = 1;
            score_temp = 0;
            
            //最高分数
            if (score > best_score) {
                best_score = score;
            }
            
            main();
               
        }
        else if (button_D.read() == 1) {
            
            score_temp = score;
            level = 3;
            
            lcd.clear();
            
            lcd.printString("THE LAST",18,2);
            lcd.printString("DEFENCE",21,4);
            
            lcd.refresh();
            
            thread_sleep_for(200);
            
            this->monster_main3(lcd, button_A, button_B, button_C, button_D, led1, led2, led3);
            
        }
        
    }
    
}

//**********************************************第三关********************************************************//

//第三关
void Monster::monster_main3(N5110 &lcd, DigitalIn &button_A, DigitalIn &button_B, DigitalIn &button_C, DigitalIn &button_D,
                           DigitalOut led1, DigitalOut led2, DigitalOut led3) {
    
    //初始化暂停键
    joy_button.fall(&joy_button_isr);
    joy_button.mode(PullDown);
    joy_button_flag = 0;
    
    //初始化自动攻击
    auto_attack = false;
    
    //设置人物初始位置
    monster_x0 = 0;
    
    //初始化时间计数
    time_count = 0;
    
    //初始化反派
    bullets.clear();
    monster_a.clear();
    monster_b.clear();
    monster_c.clear();
    
    while(1) {
     
        lcd.clear();
        
        //最后的防线
        lcd.drawLine(28,9,28,48,2);
        
        //画分数
        this->drawscores(lcd);
        
        //画反派a,b,c
        this->draw_blackmonsters3(lcd);
        
        //画人物
        this->draw_monster_level3(lcd);
        
        //画子弹monster
        this->draw_bullets(lcd,button_A);
        
        //画生命
        this->drawlifes(lcd, led1, led2, led3);
                
        lcd.refresh();
        
        if (lifes <= 0) {
            break;
        }
        
        //暂停
        if (joy_button_flag == 1) {
            
            this->pause(lcd,button_A,button_B);
            
        }
        
        //自动攻击
        if (button_C == 1) {
            auto_attack = !auto_attack;
        }
        
        time_count += 1;
        if (time_count%3 == 0) {
            fire = true;   
        }
        
        thread_sleep_for(15);
        
    }
    
    //游戏结束
    this->game_over(lcd,button_A);
    
    
}

void Monster::draw_blackmonsters3(N5110 &lcd) {
    
    //画反派c
    if ((time_count % 71) == 0) {
        for (int j = 0; j < monster_c.size(); j++) {
            
            if ( monster_c[j].x < 0 ) {
                
                monster_c[j].x = 84;
                monster_c[j].y = random(10,35);
                add_monster = false;
                break;
            }
        }
        
        if (add_monster == true) {
            m_c.x = 84;
            m_c.y = random(10,35);
            monster_c.push_back(m_c);
        }
        add_monster = true;
    }
    
    for (int i_c = 0; i_c < monster_c.size(); i_c++) {
        
        monster_c[i_c].x -= 1;
        lcd.drawSprite(monster_c[i_c].x,monster_c[i_c].y,10,11,(int *)blackMonster_shield);
        
        for (int i = 0; i < bullets.size(); i++) {
            
            if ( bullets[i].y < (monster_c[i_c].y+10) &&  bullets[i].y > (monster_c[i_c].y-3) && bullets[i].x > (monster_c[i_c].x-5) && bullets[i].x < (monster_c[i_c].x+11)) {
             
                bullets[i].x = 100;
                monster_c[i_c].lives -= 1;
                
            }
            
        }
        
        if (monster_c[i_c].lives == 0) {
            monster_c[i_c].lives = 5 + (time_count/1000);
            monster_c[i_c].x = -100;
            score += 1;
        }
        
        if (monster_c[i_c].x <29 && monster_c[i_c].x >0) {
            monster_c[i_c].x = -100;
            lifes -= 1;
        }
        
    }
    
    //画反派b
    if ((time_count % 61) == 0) {
        for (int j_b = 0; j_b < monster_b.size(); j_b++) {
            
            if ( monster_b[j_b].x < 0 ) {
                
                monster_b[j_b].x = 84;
                monster_b[j_b].y = random(10,35);
                add_monster = false;
                break;
            }
        }
        
        if (add_monster == true) {
            m_b.x = 84;
            m_b.y = random(10,35);
            monster_b.push_back(m_b);
        }
        add_monster = true;
    }
    
    for (int i_b = 0; i_b < monster_b.size(); i_b++) {
        
        monster_b[i_b].x -= 2;
        lcd.drawSprite(monster_b[i_b].x,monster_b[i_b].y,6,11,(int *)blackMonster_sword);
        
        for (int i = 0; i < bullets.size(); i++) {
            
            if ( bullets[i].y < (monster_b[i_b].y+6) &&  bullets[i].y > (monster_b[i_b].y-3) && bullets[i].x > (monster_b[i_b].x-5) && bullets[i].x < (monster_b[i_b].x+11)) {
             
                bullets[i].x = 100;
                monster_b[i_b].lives -= 1;
                
            }
            
            if (monster_b[i_b].lives == 0) {
                monster_b[i_b].lives = 2 + (time_count/1500);
                monster_b[i_b].x = -100;
                score += 1;
            }
            
        }
        
        if (monster_b[i_b].x <29 && monster_b[i_b].x >0) {
            monster_b[i_b].x = -100;
            lifes -= 1;
        }
        
    }
    
    //画反派a
    if ((time_count % 41) == 0) {
        for (int j_a = 0; j_a < monster_a.size(); j_a++) {
            
            if ( monster_a[j_a].x < 0 ) {
                
                monster_a[j_a].x = 84;
                monster_a[j_a].y = random(10,35);
                add_monster = false;
                break;
            }
        }
        
        if (add_monster == true) {
            m_a.x = 84;
            m_a.y = random(10,35);
            monster_a.push_back(m_a);
        }
        add_monster = true;
    }
    
    for (int i_a = 0; i_a < monster_a.size(); i_a++) {
        
        monster_a[i_a].x -= 2;
        lcd.drawSprite(monster_a[i_a].x,monster_a[i_a].y,7,7,(int *)blackMonster);
        
        for (int i = 0; i < bullets.size(); i++) {
            
            if ( bullets[i].y < (monster_a[i_a].y+6) &&  bullets[i].y > (monster_a[i_a].y-3) && bullets[i].x > (monster_a[i_a].x-5) && bullets[i].x < (monster_a[i_a].x+11)) {
             
                bullets[i].x = 100;
                monster_a[i_a].x = -100;
                score += 1;
                
            }
            
        }
        
        if (monster_a[i_a].x <29 && monster_a[i_a].x >0) {
            monster_a[i_a].x = -100;
            lifes -= 1;
        }
        
    }
    
    
}

//画人物level 3
void Monster::draw_monster_level3(N5110 &lcd) {
    
    if (joy_h.read() < 0.25 && lcd.getPixel(monster_x0+8,monster_y0) == 0 && lcd.getPixel(monster_x0+8,monster_y0+3) == 0 && lcd.getPixel(monster_x0+8,monster_y0+5) == 0) {
        monster_x0 += 1;  
    }
    else if (joy_v.read() > 0.75 && lcd.getPixel(monster_x0,monster_y0-1) == 0 && lcd.getPixel(monster_x0+7,monster_y0-1) == 0) {
        monster_y0 -= 1;  
    }
    else if (joy_h.read() > 0.85 && lcd.getPixel(monster_x0-1,monster_y0) == 0 && lcd.getPixel(monster_x0-1,monster_y0+3) == 0 && lcd.getPixel(monster_x0-1,monster_y0+5) == 0) {
        monster_x0 -= 1;  
    }
    else if (joy_v.read() < 0.3 && lcd.getPixel(monster_x0,monster_y0+6) == 0 && lcd.getPixel(monster_x0+7,monster_y0+6) == 0) {
        monster_y0 += 1;  
    }
    
    //向左限定
    if (monster_x0 < 0) {
       monster_x0 = 0;
    }
    //向右限定
    if (monster_x0 > 15) {
       monster_x0 = 15;
    }
    //向上限定
    if (monster_y0 < 9) {
       monster_y0 = 9;
    }
    //向下限定
    if (monster_y0 > 41) {
        monster_y0 = 41;   
    }
    
    lcd.drawSprite(monster_x0,monster_y0,6,11,(int *)whiteMonster_sword);
      
}

//攻击
void Monster::draw_bullets(N5110 &lcd, DigitalIn &button_A) {
    
    if ((button_A == 1 || auto_attack == true) && fire == true) {
        
        for (int j = 0; j < bullets.size(); j++) {
            
            if ( bullets[j].x >= 100 ) {
                
                bullets[j].x = monster_x0+2;
                bullets[j].y = monster_y0+2;
                add_bullets = 0;
                break;
            }
        }
        
        if (add_bullets == 1) {
            buls.x = monster_x0+2;
            buls.y = monster_y0+2;
            bullets.push_back(buls);
        }
        add_bullets = 1;
        fire = false;
    }
    
    for (int i = 0; i < bullets.size(); i++) {
        
        bullets[i].x += 10;
        lcd.drawSprite(bullets[i].x,bullets[i].y,3,2,(int *)bullet);
        
        if (bullets[i].x > 78) {
            
            bullets[i].x = 100;
            
        }
        
    }
    
    //****************************//
    /*
    int t = bullets.size();
    char c[14];
    sprintf(c,"%d",t);
    lcd.printString(c,40,5);
    */
    
}
















                       


