/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "N5110.h"

#include "monster.h"
#include "play.h"
#include "shapes.h"
#include "main.h"


// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

N5110 lcd(p8,p9,p10,p11,p13,p21);
DigitalIn button_A(p29);
DigitalIn button_B(p28);
DigitalIn button_C(p27);
DigitalIn button_D(p26);

Monster monster;

void init();
void welcome();
void instruction();

int main()
{
    
    init();
    welcome();
    
    while(1) {
        
        if (button_A.read() == 1 ) {
        
        choice();
           
        }
        
    }
    
    
}

void init() {
    
    lcd.init();
       
}

void welcome() {
    
    lcd.clear();
    
    lcd.drawSprite(60,12,12,14,(int *)bigMonster);
    lcd.printString("Monster",0,0);
    lcd.printString("Game",0,2);
    
    lcd.printString("Press A  NEXT",0,5);
    
    // thread_sleep_for(200);
    lcd.refresh();
    
}

void choice() {

    lcd.clear();
    
    lcd.printString("A. BEGIN",0,0);
    lcd.printString("B. SCORE",0,2);
    lcd.printString("C. INFO",0,4);
    
    lcd.refresh();
    
    thread_sleep_for(50);
    
    while(1) {
        
        if(button_A.read() == 1) {
              get_start(lcd);
              monster.draw(lcd);
        }
        if(button_B.read() == 1) {
              show_score(lcd,button_A);
        }
        if(button_C.read() == 1) {
              instruction();
        }
           
    }
   
}


void instruction() {
    
    lcd.clear();
    
    lcd.drawSprite(0,0,6,7,(int *)whiteMonster);
    lcd.drawSprite(0,9,7,7,(int *)blackMonster);
    lcd.drawSprite(2,19,3,3,(int *)shapStar);
    lcd.drawSprite(1,26,4,5,(int *)shapHeart);
    
    lcd.printString("Your monster",12,0);
    lcd.printString("Enemy",12,1);
    lcd.printString("Jewel",12,2);
    lcd.printString("Lives",12,3);
    
    lcd.printString("Press A   BACK",0,5);
    
    // thread_sleep_for(200);
    lcd.refresh();
    
    while(1) {
     
        if(button_A.read() == 1) {
            choice();
        }    
    }
    
}



