#include "mbed.h"
#include <stdint.h>

#ifndef MBED_LINEFOLLOWER_H
#define MBED_LINEFOLLOWER_H

class LineFollower{

    public:
    /** Create a Line Follower interface for an IR Sensor Array
    *
    * @param ir1  IR Sensor 1
    * @param ir2  IR Sensor 2
    * @param ir3  IR Sensor 3
    * @param ir4  IR Sensor 4
    * @param ir5  IR Sensor 5
    * @param ir6  IR Sensor 6
    * @param ir7  IR Sensor 7
    * @param ir8  IR Sensor 8
    */   
    Linefollower(DigitalIn ir1, DigitalIn ir2, DigitalIn ir3, DigitalIn ir4,
                DigitalIn ir5, DigitalIn ir6, DigitalIn ir7, DigitalIn ir8);
                
                    
    /** Read the value of a LineFollower object
    * 
    * @return The value of the Sensor
    */                    
    uint8_t read();
    
    /** Follow a line
    * 
    * @param    l left drive motor
    * @param    r  right drive motor
    */                    
    void followLine(Motor l, Motor r);
        
    protected:
    /* Constants */
    #define ROTATE_SPEED    100
    #define MAXSPEED        1
    
    /* Attributes */
    DigitalIn array[8];
    DigitalIn _ir1;
    DigitalIn _ir2;
    DigitalIn _ir3;
    DigitalIn _ir4;
    DigitalIn _ir5;
    DigitalIn _ir6;
    DigitalIn _ir7;
    DigitalIn _ir8;
    

};

#endif