/* Mbed Wiegand library
 * Copyright (c) 2014, 
 *      Colin Bookman, cobookman [at] gmail [dot] com 
 *      Sarthak Jaiswal sjaiswal3 [at] gatech [dot] edu
 *      Avnish Kumar  akumar96 [at] gatech [dot] edu
 * 
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MBED_MICIO_H
#define MBED_MICIO_H

#include "mbed.h"

/**
 * @code
 * #include "Wiegand.h"
 * 
 * Wiegand wiegand(pin data0, pin data1, pin hold, onRFIDRead); data0/data1 are ISR Inputs, hold = digital Out
 * 
 * @endcode
 */
class Wiegand {
public:

    /* Create a Wiegand instance, and attach interrupts */
    Wiegand(PinName pdata0, PinName pdata1, PinName pHold, void (*onCardRead)());
    
    /* Check if we've read all card data */
    void doEvents(void);
    
    /* return number of bits currently read */
    uint8_t bitsRead(void);
    
    /* Returns the bits read from in [start,end] (Inclusive) */
    uint64_t getBits(uint8_t start, uint8_t end);
    
protected:
    InterruptIn _data0ISR;
    InterruptIn _data1ISR;
    DigitalOut  _hold;
    Timer _lastISR;

    void (*_onCardRead)(); //callback function
    
    /* Internal buffer of wiegand data */
    volatile uint8_t _buffer[64];
    uint8_t _sizeOfBuffer;
    
    /* Number of bits currently read */
    volatile uint8_t _bitsRead;
    
    /* Reset buffer */
    void _resetBuffer(void);
    
    /* Attaches ISR Routines */
    void _attachInterrupts(void);
    
    /* ISR Routine for data 0 */    
    void _data0ISRAction(void);
    
    /* ISR Routine for data 1 */
    void _data1ISRAction(void);
    
};

#endif
