#include "mbed.h"
#include "Wiegand.h"
#include "USBMouseKeyboard.h"
/* Prototypes */
void onCardRead();

/* Globals */
          //(PinName pdata0, PinName pdata1, PinName pHold, void (*onCardRead)());
Wiegand rfid(p30           , p29           , p28          , &onCardRead);

/*
  hook up to a usb breakout board: D+ to D+, d- to d-, grnd to grnd
  If you do not have the usb breakout board for keyboard emulation,
  you can use Serial over USB by changing the USBMouseKeyboard line to read:
  Serial key_mouse(USBTX, USBRX);
*/
USBMouseKeyboard key_mouse; 
int main() {
    while(1) {
        rfid.doEvents(); //check if RFID Reader has read all data
    }
}
//function is run every time that rfid finishes reading a buzzcard
void onCardRead() {
   uint64_t rawCardData = rfid.getBits(14,33);
   key_mouse.printf("%lld\r\n",rawCardData);
}
