/*
#include "mbed.h"
#include "arm_book_lib.h"
#include "Dht22.h"
#include "Tiempo.h"
#include "Sistema.h"

int main() {
    // imprimo mensaje de bienvenida
    printf("\nProyecto integrador\n");
    printf("-------------------\n");
    // espero se estabilice el sensor DHT
    delay(1);
    // variable de tiempo
    Tiempo tiempo(26, 5, 2021, 22, 45, 0);
    // variable del sistema
    Sistema sistema(tiempo, 0.3f, 22.0f, PA_0, PF_8, A0, PE_12, PE_10);
    // bucle infinito
    while (true) {}
}
*/

#include "mbed.h"
#include "arm_book_lib.h"
#include "Dht22.h"
#include "Tiempo.h"
#include "Sistema.h"

// temporizador y cola de mensajes
Ticker temporizador;
EventQueue cola;

// variable de tiempo
Tiempo tiempo(26, 5, 2021, 15, 41, 40);
//Sistema sistema(tiempo, 0.3f, 22.0f, A0, PE_12, PA_0, PF_8, PE_10);

// entradas y salidas
PwmOut luz(PA_0);
PwmOut ventilador(PF_8);
AnalogIn luminosidad(A0);
Dht22 temperaturaHumedad(PE_12); 
DigitalOut sirena(PE_10);

// parametros del sistema
float const minimaLuz = 0.3f;
int const maximaTemperatura = 20;


// control de lecturas
int contadorLecturas= 0;
int const lecturas = 12;

// variables usadas para luminosidad
float acumuladorLuminosidad = 0.0;
float valorLuminosidad = 0.0;

// variables usadas para temperatura y humedad
int contadorLecturasValidas = 0;
float acumuladorTemperatura = 0.0;
float acumuladorHumedad = 0.0;
float valorTemperatura = 0.0;
float valorHumedad = 0.0;

void actualizarSistema() {
    // luminosidad
    contadorLecturas++;
    acumuladorLuminosidad += luminosidad.read();
    // temperatura y humedad
    if (temperaturaHumedad.read() == 0) {
        contadorLecturasValidas++;
        acumuladorTemperatura = acumuladorTemperatura + temperaturaHumedad.getCelsius();
        acumuladorHumedad = acumuladorHumedad + temperaturaHumedad.getHumidity();
    } else {
        printf("Error al leer DHT22 \n");
    }

    // si se realizan las lecturas necesarias
    if (contadorLecturas == lecturas) {
        // promedio de lecturas
        valorLuminosidad = acumuladorLuminosidad / contadorLecturas;
        valorTemperatura = acumuladorTemperatura / contadorLecturasValidas;
        valorHumedad = acumuladorHumedad / contadorLecturasValidas;
        // imprimo datos
        printf("Luminosidad: %.2f (%.2f / %d)\n", valorLuminosidad, acumuladorLuminosidad, contadorLecturas);
        printf("Temperatura: %.2f (%.2f / %d)\n", valorTemperatura, acumuladorTemperatura, contadorLecturasValidas);
        printf("Humedad:     %.2f (%.2f / %d)\n", valorHumedad, acumuladorHumedad, contadorLecturasValidas);
        // si la lumninosidad es menor a la necesaria        
        if (valorLuminosidad <= minimaLuz && luz == OFF) {
            // activo led
            sirena = ON;
            printf("Activando led\n");
            luz = ON;
            sirena = OFF;
        } 
        if (valorLuminosidad > minimaLuz && luz != OFF) {
            // desactivo led
            sirena = ON;
            printf("Desactivando led\n");
            luz = OFF;
            sirena = OFF;
        }
        // control de ventilador
        if (valorTemperatura >= maximaTemperatura && ventilador == 0) {
            // activo led
            sirena = ON;
            printf("Activando ventilador\n");
            ventilador = 1;
            sirena = OFF;
        } 
        if (valorTemperatura < maximaTemperatura && ventilador != 0) {
            // desactivo led
            sirena = ON;
            printf("Desactivando ventilador\n");
            ventilador = 0;
            sirena = OFF;
        }
        
        // reinicio variables para promedio siguiente
        contadorLecturas = 0;
        contadorLecturasValidas = 0;
        acumuladorLuminosidad = 0.0;
        acumuladorTemperatura= 0.0;
        acumuladorHumedad = 0.0;
    }
}

int main() {
    // imprimo mensaje de bienvenida
    printf("\nProyecto integrador\n");
    printf("-------------------\n");
    // espero se estabilice el sensor DHT
    delay(1);
    // hilo para manejar eventos
    Thread hiloEventos;
    hiloEventos.start(callback(&cola, &EventQueue::dispatch_forever));
    // temporizador cada 5 segundos
    temporizador.attach(cola.event(&actualizarSistema), 5);
    // bucle infinito
    while (1) {}
}