#include "mbed.h"
#include <vector>

Serial pc(USBTX, USBRX); // tx, rx
Serial device(p13, p14);  // tx, rx
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalIn outCheck(p29);
Timer t;
PwmOut IRLED(p21);

struct arrContainer {
    uint8_t buffer[20];  
};
//IR send and receive demo
//LED1 and LED2 indicate TX/RX activity
//Character typed in PC terminal application sent out and returned back using IR transmitter and receiver

int main() {
    //IR Transmit code
    IRLED.period(1.0/38000.0);
    IRLED = 0.5;
    //Drive IR LED data pin with 38Khz PWM Carrier
    //Drive IR LED gnd pin with serial TX
    device.baud(2400);
    vector<arrContainer> inputs;
    inputs.push_back(arrContainer());
    int currInput = 0;
    int currLocation = 0;
    myled1 = 0.0;
    bool irInput = false;
    bool shouldPrint = true;
    t.start();
    uint8_t temp;
    while(1) {
        
        //IR Receive code
        if(device.readable()) {
            if (temp = device.getc() && shouldPrint) {
                if (currLocation < 20) {
                    inputs[currInput].buffer[currLocation++] = temp;
                } else {
                    pc.printf("Full");
                }
                if (shouldPrint)
                    pc.putc(temp);
                t.reset();
                irInput = true;
            }
        }
        // If more than 4 seconds has passed since receiving
        // a signal, store the data and await next input.
        if ((t.read() > 4) && irInput) {
            currInput++;
            inputs.push_back(arrContainer());
            currLocation = 0;
            pc.printf("   Confirmed! \n\r");
            irInput = false;
        }
        // If more than 8 seconds has passed resend the data
        // and output to terminal
        if (t.read() > 8 && outCheck) {
            for (int i = 0; i < currInput; i++) {
                for (int j = 0; j < 20; ++ j) {
                    device.putc(inputs[i].buffer[j]);
                    if (device.readable())
                        pc.putc(device.getc());
                }
            }
            irInput = false;
            shouldPrint = false;
            wait(5);
        }
    }
}
