#include "mbed.h"
#include "LSM303DLH.h"

Serial debug(USBTX,USBRX);
LSM303DLH compass(p28, p27);

int main() {
  float hdg;
  float hdgV;
  vector acc;
  vector mag;
  debug.format(8,Serial::None,1);
  debug.baud(9600);
  debug.printf("LSM303DLH Test\r\n");
  compass.setOffset(0,0,0);            // example calibration
  compass.setScale(1.00,1.00,1.00);    // example calibration
  while(1) {
    compass.read(acc,mag);
    hdg = compass.heading();
    hdgV = atan2(acc.y,acc.x) * 180/M_PI;
    debug.printf("ACC:  %6.2f %6.2f %6.2f\r\n",acc.x,acc.y,acc.z);
    debug.printf("MAG:  %6.2f %6.2f %6.2f\r\n",mag.x,mag.y,mag.z);
    debug.printf("HEAD: %6.2f %6.2f\r\n",hdgV,hdg);
    debug.printf("\r\n");
    wait(1);
  }
}