#include "TinyQueue.h"




/**
 * \brief Push an Accessibility Event onto our queue for sending to the iphone
 * \param q pointer to our tinyQ_t
 * \param c the Event to send to the iphone
 * \return null if Q full,  1 on success
 * \sa Qpop(), Qjump()
 * \ingroup tinyQ
 */
int Qpush( tinyQ_t* q, void* p )
{
   if (q->fill >= Q_SIZE)
      return 0;

   q->fill++;
   q->data[q->head++] = p;

   return 1;
}

/**
 * \brief Push an Accessibility Event onto front of our queue for sending to the iphone
 * \param q pointer to our tinyQ_t
 * \param c the Event to send to the iphone
 * \return null if Q full, 1 on success
 * \sa Qpush(), Qpop()
 * \ingroup tinyQ
 */
int Qjump( tinyQ_t* q, void* p)
{
   if (q->fill >= Q_SIZE)
      return 0;

   q->fill++;
   q->data[--q->tail] = p;

   return 1;
}

/**
 * \brief Pop an Accessibility Event off our queue for sending to the iphone
 * \param q pointer to our tinyQ_t
 * \param c pointer to receive the Event
 * \return null if Q empty, 1 on success
 * \sa Qpop(), Qjump()
 * \ingroup tinyQ
 */
int Qpop( tinyQ_t* q, void **p)
{
   if (! q->fill )
      return 0;

   q->fill--;
   *p = q->data[q->tail++];

   return 1;
}

/* @} */