// Relay bytes received as SPI slave to PC-USB-Serial

#include <string>
#include "mbed.h"
//#include "Terminal.h"
#include "MODSERIAL.h"
#include "stripe.h"
#include "TinyQueue.h"

 
MODSERIAL   pc(USBTX,NC,4096);
Serial      wt(NC,p10);
Serial      r8(NC,p14);

DigitalOut  ledCTS(LED1);
DigitalOut  ledRTS(LED2);
//DigitalOut  ledOV(LED4);
Timeout     toCTSLed;
Timeout     toRTSLed;
Timeout     icto;
/*InterruptIn  nCTS(p11);
InterruptIn  nRTS(p12);
*/
DigitalIn   nCTS(p18);
DigitalIn   nRTS(p19);
tinyQ_t     outQ;

#define BAUD (115200)


Stripe * pStripe;

Stripe* newStripe()
{
    static char alt;
    return new Stripe(249+(alt++%2)*4,124,19);
}

void offCTSLed(void)
{
    ledCTS = 0;
}

void onCTSLed(void)
{
    ledCTS = 1;
    toCTSLed.attach(offCTSLed,0.1);
}

void offRTSLed(void)
{
    ledRTS = 0;
}

void onRTSLed(void)
{
    ledRTS = 1;
    toRTSLed.attach(offRTSLed,0.1);
}

void ctsFall(void)
{
    onCTSLed();
}

void rtsFall(void)
{
    onRTSLed();
}

/* flush Stripes after no activity */
void flush( void )
{
    Qpush(&outQ, (void*)pStripe);
    pStripe = newStripe();
}

// This function is called when a character goes into the RX buffer.
void rxCallbackWT(void) {
    if ( ! pStripe->inbyte(wt.getc()) )
    {
        Qpush(&outQ, (void*)pStripe);
        pStripe = newStripe();
    }
    icto.attach(flush,0.5);
}

void rxCallbackR8(void) {
    if ( ! pStripe->outbyte(r8.getc()) )
    {
        Qpush(&outQ, (void*)pStripe);
        pStripe = newStripe();
    }
    //icto.attach(flush,0.5);
}
  
int main()
{
    char c=0;
    
    pc.baud(BAUD);
    wt.baud(BAUD);
    r8.baud(BAUD);
           
    //nCTS.mode(PullUp);
    //nRTS.mode(PullUp);
    
    
    wt.attach(&rxCallbackWT, Serial::RxIrq);
    r8.attach(&rxCallbackR8, Serial::RxIrq);
    
    pc.printf("==== Snoop dog ready... ===\n");
    
    pStripe = newStripe();

    while(1)
    {
        Stripe * pStripe;
    
        if ( Qpop(&outQ,(void**)&pStripe) )
        {
            while ( c = pStripe->getc() )
                pc.putc(c);
            
            delete pStripe;
        }
    }
}
