#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "stripe.h"
#include "mbed.h"

#define sprintf mysprintf

int mysprintf( char * str, const char * format, ... )
{
    char s[50];
    va_list ap;
    
    va_start(ap,format);
    vsprintf(s,format,ap);
    va_end(ap);
    
    strncpy(str,s,strlen(s));
    return strlen(s);
}
    
Stripe::Stripe( uint8_t bc, uint8_t oc, uint8_t ic  )
{
    
    memset((void*)&(this->strip),0x20,sizeof(Strip));
    sprintf(this->strip.bgc, "\033[48;5;%03um", bc );
    sprintf(this->strip.row[0].fgc, "\033[38;5;%03um", oc );
    sprintf(this->strip.row[1].fgc, "\033[38;5;%03um", ic );
    sprintf(this->strip.row[0].eol, "\n\r" );
    sprintf(this->strip.row[1].eol, "\n\r" );
    this->wp = 0;
    this->rp =0;
    
}


int Stripe::advance( void )
{
    if ( ++ wp >= 16 )
        return 0;
    else
        return 1;
}

int Stripe::inbyte( uint8_t b )
{
    sprintf(&strip.row[1].hex[wp*3], "%02X ", b );
    
    if (b >=0x20 && b<=0x80)
    {
         strip.row[1].asc[wp] = b;
    }else{
         strip.row[1].asc[wp] = '.';
    }
    return advance();
}

int Stripe::outbyte( uint8_t b )
{
    sprintf(&strip.row[0].hex[wp*3], "%02X ", b );
    
    if (b >=0x20 && b<=0x80)
    {
         strip.row[0].asc[wp] = b;
    }else{
         strip.row[0].asc[wp] = '.';
    }
    return advance();
}

uint8_t Stripe::getc( void )
{
    char c;
    
    while ( rp < sizeof(strip) )
    {
        c = ((char*)(&strip))[rp++];
        if (c)
            return c;
    }
    return 0;
}
