#include "string.h"
#include "tinyQ.h"



/**
 * \brief Push an Accessibility Event onto our queue for sending to the iphone
 * \param q pointer to our tinyQ_t
 * \param c the Event to send to the iphone
 * \return null if Q full,  1 on success
 * \sa Qpop(), Qjump()
 * \ingroup tinyQ
 */
int Qpush( tinyQ_t* q, char c )
{
   if ( q->fill == Q_SIZE )
    return 0;
    
   __disable_irq();
   q->fill++;
   q->data[q->head++] = c;
   __enable_irq();
   
   return 1;
}


/**
 * \brief Pop an Accessibility Event off our queue for sending to the iphone
 * \param q pointer to our tinyQ_t
 * \param c pointer to receive the Event
 * \return null if Q empty, 1 on success
 * \sa Qpop(), Qjump()
 * \ingroup tinyQ
 */
 int Qpop( tinyQ_t* q, char * c)
{
   if (! q->fill )
      return 0;
      
   __disable_irq();
   q->fill--;
   *c = q->data[q->tail++];
   __enable_irq();
   
   return 1;
}

int Qfree( tinyQ_t* q )
{
    return (Q_SIZE - q->fill);
}

void Qinit( tinyQ_t * q )
{
    memset( q, 0, sizeof(q) );
}
