// Relay bytes received as SPI slave to PC-USB-Serial

#include "mbed.h"
#include "MODSERIAL.h"

//SPISlave    slave(p5, NC, p7, p8);
SPISlave    slave(p11, NC, p13, p14);
MODSERIAL   pc(USBTX,NC,1024,0);
//Serial    pc(USBTX,NC);
DigitalOut  ledTX(LED1);
DigitalOut  ledRX(LED2);
DigitalOut  ledOV(LED4);
Timeout     toRXLed;


#define fSPI (5000000)
#define BAUD (115200)


void offRXLed(void)
{
    ledRX = 0;
}

void onRX(void)
{
    ledRX = 1;
    toRXLed.attach(offRXLed,0.1);
}

// This function is called when a character goes from the TX buffer
// to the Uart THR FIFO register.
void txCallback(MODSERIAL_IRQ_INFO *q) {
    ledTX = 1;
}

// This function is called when TX buffer goes empty
void txEmpty(MODSERIAL_IRQ_INFO *q) {
    ledTX = 0;
}   

// This function is called when TX buffer is Overrun
void txOVR(MODSERIAL_IRQ_INFO *q) {
    ledOV = 1;
}

  
int main()
{
    pc.baud(BAUD);
    slave.frequency(fSPI);
    pc.attach(&txEmpty,    MODSERIAL::TxEmpty);
    pc.attach(&txCallback,    MODSERIAL::TxIrq);
    pc.attach(&txOVR,    MODSERIAL::TxOvIrq);
    
    pc.printf("\n==== SPI 2 USB ready... ===\n");

    while(1)
    {
        while ( !slave.receive()  );
        {
            pc.putc( slave.read() );   // Read byte from master
            onRX();
        }
    }
}