#include "mbed.h"

#define BCSP 0

//I2C acp(p9, p10);
Serial serBT(p28,p27);
Serial serPC(USBTX,USBRX);

InterruptIn  intCD(p22);

DigitalOut ledBT(LED1);
DigitalOut ledDAT(LED2);
DigitalOut ledCD0(LED3);
DigitalOut ledCD(LED4);

DigitalOut outBTRES(p24);
DigitalOut outDTR(p23);

Timeout toBTled;

void timeoutBt(void)
{
    ledBT = 0;
}

void goOffline( void )
{
    serPC.printf("CMD\n");
    outDTR = 1;
    wait(0.10);
    outDTR = 0;
    //serPC.printf("DTR = %u\n",outDTR.read() );
}

void onCDUp(void)
{
    ledCD = 1;
    serPC.printf("CD up\n");
}

void onCDDn(void)
{
    ledCD = 0;
    serPC.printf("CD dn\n");
}

void ledBTOn(void)
{
    ledBT = 1;
    toBTled.attach(timeoutBt,0.1);
}

void resetBT(void)
{
    outBTRES = 1;
    wait(0.010);
    outBTRES = 0;
}

int main() {
    serPC.baud(115200);
    serBT.baud(115200);
 
    //serBT.format( 8, Serial::Even, 1 );
   // serBT.format( 8, Serial::None, 1 );
 
    serPC.format( 8, Serial::Even, 1 );
    
    intCD.rise(onCDUp);
    intCD.fall(onCDDn);
    ledBT = 0; 

    serPC.printf("Mbed starting\n");
    resetBT();
    
    wait(0.5);
    serBT.printf("INFO\n");
    
    while(1) {
        char c;

        if(serPC.readable()) {
            c = serPC.getc();
            #if !BCSP
            if ( c == 0x1B )
                goOffline();
            else
            #endif
            {
                ledBTOn();
                serBT.putc(c);
            }
        }
        
        if(serBT.readable()) {
            ledBTOn();
            c = serBT.getc();
            serPC.putc(c);
        }    
    }
}
    