//
// TBR19 Hydraulics Communication
//
// Christopher Bull
//
// Hydraulic control unit CAN communication mbed code which converts PWM signals
// to CAN messages and vice versa
//
// A configuration file for CAN IDs and sensor value adjustments is included 
// under "config.h"
//


// Include files and libraries required, also includes mbed library
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include "mbed.h"
#include "config.h"
#include "can_instruction_set.h"
#include "mcp_reg_addresses.h"
#include "hydraulics_instruction_set.h"


Serial pcMain(USBTX, USBRX);        // USB output and input for LPC1768 and PC



// Main sensor conditioning function consists of setup before entering an 
// endless loop
void main()
{   
    wait_us(100000);    // Wait for electronics to stablise before setup
    configSPI();        // Setup SPI with STM32 chip
    resetCAN();         // Reset the CAN controller with SPI command
    configCAN();        // Setup CAN controller with configuration.h file  
    
    pcMain.printf("Here");
    monitorSignals();     // Enter endless loop of hydraulics monitoring
    return;    
}
    
