#include "mbed.h"
#include "config.h"
#include "can_instruction_set.h"


AnalogIn    clutchPosSensor(p18);  
AnalogIn    clutchDemSensor(p19);  
AnalogIn    gearActPosSensor(p20); 
Serial      pcHydCAN(USBTX, USBRX);

// Launch Sw 1 = 21 2 =22


void monitorSignals()
{
    uint16_t clutchPosRaw = 0;
    uint16_t clutchDemRaw = 0;
    uint16_t gearActPosRaw = 0;
    
    uint16_t clutchPosScaled = 0;
    uint16_t clutchDemScaled = 0;
    uint16_t gearActPosScaled = 0;
    
    // Main programme loop, continues until board reset switch is pressed
    // receives sensor values, formats them and then sends data to CAN bus 
    while(1)
    {
        if(CLUTCH_POS_ON == 1)
        {
            clutchPosRaw = clutchPosSensor.read_u16();
            clutchPosScaled = clutchPosRaw / 64;            
        }
        if(HAND_CLUTCH_ON == 1)
        {        
            clutchDemRaw = clutchDemSensor.read_u16();
            clutchDemScaled = clutchDemRaw / 64;
        }
        if(GEAR_ACT_POS_ON == 1)
        {
            gearActPosRaw = gearActPosSensor.read_u16();
            gearActPosScaled = gearActPosRaw / 64;
        }

        uint8_t hydData[8];
        hydData[6] = 0x00;
        hydData[7] = 0x01;
        hydData[4] = (gearActPosScaled >> 8) & 0b11111111;
        hydData[5] = gearActPosScaled & 0b11111111;
        hydData[2] = (clutchPosScaled >> 8) & 0b11111111;
        hydData[3] = clutchPosScaled & 0b11111111;
        hydData[0] = (clutchDemScaled >> 8) & 0b11111111;
        hydData[1] = clutchDemScaled & 0b11111111;
        
        pcHydCAN.printf("%d, %d, %d, %d, %d, %d, %d", hydData[0], hydData[1], hydData[2], hydData[3], hydData[4], hydData[5], hydData[6]);
        
        // Send the displacement value along the CAN bus
        writeMessageCAN(HYDRAULICS_ID, &hydData[0], 8);
        
        wait_us(19980);
        
   
    }
}