//
// List of Addresses for the MCP2515 CAN Controller
//
// Christopher Bull
//
// Student Number: 149034423
//
// Provides all register addresses required within the MCP2515 chip including 
// flags and buffers
//


// Inclusion guard to prevent multiple instances
#ifndef MCP_REG_ADDRESSES_H_
#define MCP_REG_ADDRESSES_H_


static const int RXF0SIDH_ADD   = 0b00000000;
static const int RXF0SIDL_ADD   = 0b00000001;
static const int RXF0EID8_ADD   = 0b00000010;
static const int RXF0EID0_ADD   = 0b00000011;

static const int RXF1SIDH_ADD   = 0b00000100;
static const int RXF1SIDL_ADD   = 0b00000101;
static const int RXF1EID8_ADD   = 0b00000110;
static const int RXF1EID0_ADD   = 0b00000111;

static const int RXF2SIDH_ADD   = 0b00001000;
static const int RXF2SIDL_ADD   = 0b00001001;
static const int RXF2EID8_ADD   = 0b00001010;
static const int RXF2EID0_ADD   = 0b00001011;

static const int BFPCTRL_ADD    = 0b00001100;
static const int TXRTSCTRL_ADD  = 0b00001101;

static const int RXF3SIDH_ADD   = 0b00010000;
static const int RXF3SIDL_ADD   = 0b00010001;
static const int RXF3EID8_ADD   = 0b00010010;
static const int RXF3EID0_ADD   = 0b00010011;

static const int RXF4SIDH_ADD   = 0b00010100;
static const int RXF4SIDL_ADD   = 0b00010101;
static const int RXF4EID8_ADD   = 0b00010110;
static const int RXF4EID0_ADD   = 0b00010111;

static const int RXF5SIDH_ADD   = 0b00011000;
static const int RXF5SIDL_ADD   = 0b00011001;
static const int RXF5EID8_ADD   = 0b00011010;
static const int RXF5EID0_ADD   = 0b00011011;

static const int TEC_ADD        = 0b00011100;
static const int REC_ADD        = 0b00011101;

static const int RXM0SIDH_ADD   = 0b00100000;
static const int RXM0SIDL_ADD   = 0b00100001;
static const int RXM0EID8_ADD   = 0b00100010;
static const int RXM0EID0_ADD   = 0b00100011;

static const int RXM1SIDH_ADD   = 0b00100100;
static const int RXM1SIDL_ADD   = 0b00100101;
static const int RXM1EID8_ADD   = 0b00100110;
static const int RXM1EID0_ADD   = 0b00100111;

static const int CNF3_ADD       = 0b00101000;
static const int CNF2_ADD       = 0b00101001;
static const int CNF1_ADD       = 0b00101010;
static const int CANINTE_ADD    = 0b00101011;
static const int CANINTF_ADD    = 0b00101100;
static const int EFLG_ADD       = 0b00101101;

static const int TXB0CTRL_ADD   = 0b00110000;
static const int TXB0SIDH_ADD   = 0b00110001;
static const int TXB0SIDL_ADD   = 0b00110010;
static const int TXB0EID8_ADD   = 0b00110011;
static const int TXB0EID0_ADD   = 0b00110100;
static const int TXB0DLC_ADD    = 0b00110101;
static const int TXB0D0_ADD     = 0b00110110;
static const int TXB0D1_ADD     = 0b00110111;
static const int TXB0D2_ADD     = 0b00111000;
static const int TXB0D3_ADD     = 0b00111001;
static const int TXB0D4_ADD     = 0b00111010;
static const int TXB0D5_ADD     = 0b00111011;
static const int TXB0D6_ADD     = 0b00111100;
static const int TXB0D7_ADD     = 0b00111101;

static const int TXB1CTRL_ADD   = 0b01000000;
static const int TXB1SIDH_ADD   = 0b01000001;
static const int TXB1SIDL_ADD   = 0b01000010;
static const int TXB1EID8_ADD   = 0b01000011;
static const int TXB1EID0_ADD   = 0b01000100;
static const int TXB1DLC_ADD    = 0b01000101;
static const int TXB1D0_ADD     = 0b01000110;
static const int TXB1D1_ADD     = 0b01000111;
static const int TXB1D2_ADD     = 0b01001000;
static const int TXB1D3_ADD     = 0b01001001;
static const int TXB1D4_ADD     = 0b01001010;
static const int TXB1D5_ADD     = 0b01001011;
static const int TXB1D6_ADD     = 0b01001100;
static const int TXB1D7_ADD     = 0b01001101;

static const int TXB2CTRL_ADD   = 0b01010000;
static const int TXB2SIDH_ADD   = 0b01010001;
static const int TXB2SIDL_ADD   = 0b01010010;
static const int TXB2EID8_ADD   = 0b01010011;
static const int TXB2EID0_ADD   = 0b01010100;
static const int TXB2DLC_ADD    = 0b01010101;
static const int TXB2D0_ADD     = 0b01010110;
static const int TXB2D1_ADD     = 0b01010111;
static const int TXB2D2_ADD     = 0b01011000;
static const int TXB2D3_ADD     = 0b01011001;
static const int TXB2D4_ADD     = 0b01011010;
static const int TXB2D5_ADD     = 0b01011011;
static const int TXB2D6_ADD     = 0b01011100;
static const int TXB2D7_ADD     = 0b01011101;

static const int RXB0CTRL_ADD   = 0b01100000;
static const int RXB0SIDH_ADD   = 0b01100001;
static const int RXB0SIDL_ADD   = 0b01100010;
static const int RXB0EID8_ADD   = 0b01100011;
static const int RXB0EID0_ADD   = 0b01100100;
static const int RXB0DLC_ADD    = 0b01100101;
static const int RXB0D0_ADD     = 0b01100110;
static const int RXB0D1_ADD     = 0b01100111;
static const int RXB0D2_ADD     = 0b01101000;
static const int RXB0D3_ADD     = 0b01101001;
static const int RXB0D4_ADD     = 0b01101010;
static const int RXB0D5_ADD     = 0b01101011;
static const int RXB0D6_ADD     = 0b01101100;
static const int RXB0D7_ADD     = 0b01101101;

static const int RXB1CTRL_ADD   = 0b01110000;
static const int RXB1SIDH_ADD   = 0b01110001;
static const int RXB1SIDL_ADD   = 0b01110010;
static const int RXB1EID8_ADD   = 0b01110011;
static const int RXB1EID0_ADD   = 0b01110100;
static const int RXB1DLC_ADD    = 0b01110101;
static const int RXB1D0_ADD     = 0b01110110;
static const int RXB1D1_ADD     = 0b01110111;
static const int RXB1D2_ADD     = 0b01111000;
static const int RXB1D3_ADD     = 0b01111001;
static const int RXB1D4_ADD     = 0b01111010;
static const int RXB1D5_ADD     = 0b01111011;
static const int RXB1D6_ADD     = 0b01111100;
static const int RXB1D7_ADD     = 0b01111101;

static const int CANSTAT_ADD    = 0x0E;  // CAN status register
static const int CANCTRL_ADD    = 0x0F;  // CAN control register


#endif  // MCP_REG_ADDRESSES_H_