//
// TBR19 Sensor Conditioning and CAN Communication Module
//
// Christopher Bull
//
// Student Number: 149034423
//
// Collects data from analogue and digital pins on an LPC1768 to determine 
// vehicle sensor values, then apply conditioning for noise reduction and 
// calculate usable values for other systems on vehicle, before sending these
// values along a CAN bus using MCP2515 and MCP2561 devices and SPI
//
// A configuration file for CAN IDs and sensor value adjustments and pin inputs
// is included under "config.h"
//


// Include files and libraries required, also includes mbed library
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include "mbed.h"
#include "config.h"
#include "can_instruction_set.h"
#include "mcp_reg_addresses.h"

Serial pcMain(USBTX, USBRX); // tx, rx

int main()
{
    wait_us(100000);        // Wait for electronics to stablise before setup
    configSPI();         // Setup SPI with STM32 chip
    resetCAN();             // Reset the CAN controller with SPI command
    configCAN();         // Setup CAN controller with configuration.h file  

    bool rec = checkMessageReceivedCAN();   // Check for message reception    
    
    int* veh_speed;                         // Vehicle speed value
    veh_speed = 0;                          // Vehicle speed value
    
    // Main programme loop, continues until board reset switch is pressed
    // receives sensor values, formats them and then sends data to CAN bus 
    while(1)
    {   
        uint8_t* data;                          // Data pointer
        rec = checkMessageReceivedCAN();        // Check for message reception
        if(rec == 1)
        {
            data = readCAN(1, data);                    // Read CAN data
            int id = getID(&data[0]);                   // Determine ID of data
            int dataLength = getDataLength(&data[0]);   // Get DLC of data
               
            // If received CAN message is vehicle speed, translate it to value   
            if (id == VEH_SPEED)
            {
                veh_speed = reinterpret_cast<int*>(&data[1]);   // Get multibyte
                                                                // CAN value
            }
            free(data);                                 // Free data
        }
   
    }
}
    
