//
// TBR19 Sensor Conditioning and CAN Communication Module Configuration File
//
// Christopher Bull
//
// Student Number: 149034423
//
// This file contains the configurable components of the sensor conditiong 
// module including CAN IDs and sensor types
// All constants listed below can be configured within the specified bounds
// but does not consider clashes of ID with existing CAN systems, therefore 
// dbc files should be analysed before configuration
//


// Inclusion guard to prevent multiple instances
#ifndef CONFIG_H_
#define CONFIG_H_


// Boolean choice of whether sensor is connected to device and should be 
// measured and transmitted
static bool WHEEL_SPEED_FL_ON   = 0;
static bool WHEEL_SPEED_FR_ON   = 0;
static bool WHEEL_SPEED_RL_ON   = 0;
static bool WHEEL_SPEED_RR_ON   = 0;
static bool DAMPER_POT_FL_ON    = 0;
static bool DAMPER_POT_FR_ON    = 0;
static bool DAMPER_POT_RL_ON    = 0;
static bool DAMPER_POT_RR_ON    = 0;
static bool STEERING_ANGLE_ON   = 0;
static bool TPPS_1_NON_INV_ON   = 0;
static bool TPPS_1_INV_ON       = 0;
static bool TPPS_2_NON_INV_ON   = 0;
static bool TPPS_2_INV_ON       = 0;
static bool BSE_FRONT_ON        = 0;
static bool BSE_REAR_ON         = 0;


// CAN IDs, extended ID is automatically accounted for
static const unsigned int VEH_SPEED_ID      = 0x01;
static const unsigned int WHEEL_SPEED_FL_ID = 0x20;
static const unsigned int WHEEL_SPEED_FR_ID = 0x21;
static const unsigned int WHEEL_SPEED_RL_ID = 0x22;
static const unsigned int WHEEL_SPEED_RR_ID = 0x23;
static const unsigned int DAMPER_POT_FL_ID  = 0x24;
static const unsigned int DAMPER_POT_FR_ID  = 0x25;
static const unsigned int DAMPER_POT_RL_ID  = 0x26;
static const unsigned int DAMPER_POT_RR_ID  = 0x27;
static const unsigned int STEERING_ANGLE_ID = 0x28;
static const unsigned int TPPS_1_NON_INV_ID = 0x30;
static const unsigned int TPPS_1_INV_ID     = 0x31;
static const unsigned int TPPS_2_NON_INV_ID = 0x32;
static const unsigned int TPPS_2_INV_ID     = 0x33;
static const unsigned int BSE_FRONT_ID      = 0x34;
static const unsigned int BSE_REAR_ID       = 0x35;


// CAN DLC, data length for each sensor data segment
static const unsigned int VEH_SPEED_DLC         = 1;
static const unsigned int WHEEL_SPEED_FL_DLC    = 1;
static const unsigned int WHEEL_SPEED_FR_DLC    = 1;
static const unsigned int WHEEL_SPEED_RL_DLC    = 1;
static const unsigned int WHEEL_SPEED_RR_DLC    = 1;
static const unsigned int DAMPER_POT_FL_DLC     = 1;
static const unsigned int DAMPER_POT_FR_DLC     = 1;
static const unsigned int DAMPER_POT_RL_DLC     = 1;
static const unsigned int DAMPER_POT_RR_DLC     = 1;
static const unsigned int STEERING_ANGLE_DLC    = 1;
static const unsigned int TPPS_1_NON_INV_DLC    = 1;
static const unsigned int TPPS_1_INV_DLC        = 1;
static const unsigned int TPPS_2_NON_INV_DLC    = 1;
static const unsigned int TPPS_2_INV_DLC        = 1;
static const unsigned int BSE_FRONT_DLC         = 1;
static const unsigned int BSE_REAR_DLC          = 1;


// Sensor value offsets 
static const unsigned int VEH_SPEED_OFFS        = 0;
static const unsigned int WHEEL_SPEED_FL_OFFS   = 0;
static const unsigned int WHEEL_SPEED_FR_OFFS   = 0;
static const unsigned int WHEEL_SPEED_RL_OFFS   = 0;
static const unsigned int WHEEL_SPEED_RR_OFFS   = 0;
static const unsigned int DAMPER_POT_FL_OFFS    = 0;
static const unsigned int DAMPER_POT_FR_OFFS    = 0;
static const unsigned int DAMPER_POT_RL_OFFS    = 0;
static const unsigned int DAMPER_POT_RR_OFFS    = 0;
static const unsigned int STEERING_ANGLE_OFFS   = 0;
static const unsigned int TPPS_1_NON_INV_OFFS   = 0;
static const unsigned int TPPS_1_INV_OFFS       = 0;
static const unsigned int TPPS_2_NON_INV_OFFS   = 0;
static const unsigned int TPPS_2_INV_OFFS       = 0;
static const unsigned int BSE_FRONT_OFFS        = 0;
static const unsigned int BSE_REAR_OFFS         = 0;


// Post offset sensor value gains (multipliers)
static const unsigned int VEH_SPEED_GAIN        = 1;
static const unsigned int WHEEL_SPEED_FL_GAIN   = 1;
static const unsigned int WHEEL_SPEED_FR_GAIN   = 1;
static const unsigned int WHEEL_SPEED_RL_GAIN   = 1;
static const unsigned int WHEEL_SPEED_RR_GAIN   = 1;
static const unsigned int DAMPER_POT_FL_GAIN    = 1;
static const unsigned int DAMPER_POT_FR_GAIN    = 1;
static const unsigned int DAMPER_POT_RL_GAIN    = 1;
static const unsigned int DAMPER_POT_RR_GAIN    = 1;
static const unsigned int STEERING_ANGLE_GAIN   = 1;
static const unsigned int TPPS_1_NON_INV_GAIN   = 1;
static const unsigned int TPPS_1_INV_GAIN       = 1;
static const unsigned int TPPS_2_NON_INV_GAIN   = 1;
static const unsigned int TPPS_2_INV_GAIN       = 1;
static const unsigned int BSE_FRONT_GAIN        = 1;
static const unsigned int BSE_REAR_GAIN         = 1;


// CAN bus configuration register setup values (TBR19 runs at 1 Mbps) and
// oscillator is 16 Mhz
static const uint8_t CNF1 = 0b01000000; // SJW=2TQ, BRP=1
static const uint8_t CNF2 = 0b10001010; // BTL 1, SAM 0, Phase1=2TQ, Prop=3TQ
static const uint8_t CNF3 = 0b00000001; // SOF 0, WAKFIL 0, Phase2=2TQ


// MCP2515 interrupt and request to send registers
static const uint8_t TXRTSCTRL  = 0b00000000;       // RTS pin disable
static const uint8_t CANINTE    = 0b00000000;       // Interrupts disabled
static const uint8_t RXB0CTRL   = 0b00000000;       // RTS pin disable

#endif      // CONFIG_H_