//
// TBR19 Sensor Health Checking via CAN Communication Module
//
// Christopher Bull
//
// Student Number: 149034423
//
// Receives data from various sensors via the CAN communication protocol to
// determine if the values of the sensors are resonable or faulty
// Uses an LPC1768 in conjunction with an MCP2515 CAN controller and MCP2561
// CAN transceiver to retrieve these values
// Will result in errors printed to USB and to ".txt" file as a log as well as
// warning and error LEDs being set with the appropriate condition
//
// A configuration file for CAN IDs and sensor value adjustments is included
// under "config.h"
//


// Include files and libraries required, also includes mbed library
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include "mbed.h"
#include "config.h"
#include "can_instruction_set.h"
#include "mcp_reg_addresses.h"
#include "health_checks.h"

Serial pcMain(USBTX, USBRX); // tx, rx


int main()
{
    wait_us(100000);        // Wait for electronics to stablise before setup
    configSPI();         // Setup SPI with STM32 chip
    resetCAN();             // Reset the CAN controller with SPI command
    configCAN();         // Setup CAN controller with configuration.h file  
    resetLEDs();
    beginLog();
    
    float* wheelSpeedFL = 0;
    float* wheelSpeedFR = 0;
    float* wheelSpeedRL = 0;
    float* wheelSpeedRR = 0;
    int countFL = 0;
    int countFR = 0;
    int countRL = 0;
    int countRR = 0;
    
    // Main programme loop, continues until board reset switch is pressed
    // receives sensor values, formats them and then sends data to CAN bus 
    while(1)
    {   

        bool rec = checkMessageReceivedCAN();
        
        uint8_t* data;
        rec = checkMessageReceivedCAN();
        if(rec == 1)
        {
            data = readCAN(1, data);        // Read CAN bus mesage
            int id = getID(&data[0]);       // Get message ID
            
            // Error ID
            if(id == SENSOR_ERROR_ID)
            {
                sensorErrorReceive(data);
            }    
            
            
            // If not error ID then check the sensor IDs
            if(id == APPS_1_NON_INV_ID && APPS_RANGE_HEALTH_ON == 1)
            {
                checkRangeAPPS1(data);
            }
            
            if(id == APPS_2_INV_ID && APPS_RANGE_HEALTH_ON == 1)
            {
                checkRangeAPPS2(data);
            }
            
            if(id == BSE_FRONT_ID && BSE_F_HEALTH_ON == 1)
            {
                checkRangeBSEF(data);
            }
            
            if(id == BSE_REAR_ID && BSE_R_HEALTH_ON == 1)
            {
                checkRangeBSER(data);
            }
            
            if(id == WHEEL_SPEED_FL_ID && WHEEL_SPEED_F_RANGE_HEALTH_ON == 1)
            {
                checkRangeWheelSpeedF(data);
                wheelSpeedFL = reinterpret_cast<float*>(&data[5]);
                countFL = WHEEL_SPEED_DECAY;    // Reset count as recent speed
            }
            
            if(id == WHEEL_SPEED_FR_ID && WHEEL_SPEED_F_RANGE_HEALTH_ON == 1)
            {
                checkRangeWheelSpeedF(data);
                wheelSpeedFR = reinterpret_cast<float*>(&data[5]);
                countFR = WHEEL_SPEED_DECAY;    // Reset count as recent speed                            
            }           
            
            if(id == WHEEL_SPEED_RL_ID && WHEEL_SPEED_R_RANGE_HEALTH_ON == 1)
            {
                checkRangeWheelSpeedR(data);
                wheelSpeedRL = reinterpret_cast<float*>(&data[5]);
                countRL = WHEEL_SPEED_DECAY;
            }    
            
            if(id == WHEEL_SPEED_RR_ID && WHEEL_SPEED_R_RANGE_HEALTH_ON == 1)
            {
                checkRangeWheelSpeedR(data);
                wheelSpeedRR = reinterpret_cast<float*>(&data[5]);
                countRR = WHEEL_SPEED_DECAY;
            }                    
            
            if((id == DAMPER_POT_FL_ID || id == DAMPER_POT_FR_ID)
                 && DAMPER_POT_F_HEALTH_ON == 1)
            {
                checkRangeDamperF(data);
            }               
            
            if((id == DAMPER_POT_RL_ID || id == DAMPER_POT_RR_ID)
                && DAMPER_POT_R_HEALTH_ON == 1)
            {
                checkRangeDamperR(data);
            }             
            
            if(id == HAND_CLUTCH_ID && HAND_CLUTCH_HEALTH_ON == 1)
            {
                checkRangeHandClutch(data);
            }                     
            
            if(id == STEERING_ANGLE_ID && STEERING_ANGLE_HEALTH_ON == 1)
            {
                checkRangeSteeringAngle(data);
            }                
            
            
            // Check speeds are up to date 
            if(countFL > 0 && countFR > 0 
                && WHEEL_SPEED_F_IMPLAUS_HEALTH_ON == 1)
            {
                checkImplausibilityWheelSpeedF(*wheelSpeedFL, *wheelSpeedFR);
            }
            if(countRL > 0 && countRR > 0
                && WHEEL_SPEED_R_IMPLAUS_HEALTH_ON == 1)
            {
                checkImplausibilityWheelSpeedR(*wheelSpeedRL, *wheelSpeedRR);
            }
             
            // If wheel speeds are not out of range decrement until updated 
            if(countFL != 0)
            {
                countFL = countFL - 1;
            }

            if(countFR != 0)
            {
                countFR = countFR - 1;
            }

            if(countRL != 0)
            {
                countRL = countRL - 1;
            }
            
            if(countRR != 0)
            {
                countRR = countRR - 1;
            }

            free(data);         // Free read data array      
        }
    }
   
}
