//
// Main Functions for the TBR19 Sensor Health Checking Module
//
// Christopher Bull
//
// Student Number: 149034423
//
// Provides specific sensor health checking functions with values received from
// CAN bus reception and prints errors and warnings to both a locally stored
// ".txt" file and any connected USB PC terminal
// Also provides error and warning LED output pin signals for quick visual
// checking
//
// A configuration file for CAN IDs and sensor value adjustments is included 
// under "config.h"
//


#ifndef HEALTH_CHECKS_H_
#define HEALTH_CHECKS_H_


// Resets the error and warning LEDs to their off state
void resetLEDs();


// Creates and writes the opening lines to the error and warning log file
void beginLog();


// Checks for any sensor error signals on the CAN bus and appends to log file,
// USB, and alters LED signals based on any error messages
void sensorErrorReceive(uint8_t* data);


// Checks for out of range values in non inverted APPS, results in error 
// protocol to USB, log file, and LEDs
// Requires APPS 1 data from CAN bus
void checkRangeAPPS1(uint8_t* data);


// Checks for out of range values in inverted APPS, results in error protocol 
// to USB, log file, and LEDs
// Requires APPS 2 data from CAN bus
void checkRangeAPPS2(uint8_t* data);


// Checks for out of range values in the front BSE, results in error protocol 
// to USB, log file, and LEDs
// Requires front BSE data from CAN bus
void checkRangeBSEF(uint8_t* data);


// Checks for out of range values in the rear BSE, results in error protocol 
// to USB, log file, and LEDs
// Requires rear BSE data from CAN bus
void checkRangeBSER(uint8_t* data);


// Checks for out of range values in the front wheel speeds, results in 
// warning protocol to USB, log file, and LEDs
// Requires either front wheel speed data from CAN bus
void checkRangeWheelSpeedF(uint8_t* data);


// Checks for out of range values in the rear wheel speeds, results in 
// warning protocol to USB, log file, and LEDs
// Requires either rear wheel speed data from CAN bus
void checkRangeWheelSpeedR(uint8_t* data);


// Checks for out of range values in the front damper displacement, results in 
// warning protocol to USB, log file, and LEDs
// Requires either front damper displacement data from CAN bus
void checkRangeDamperF(uint8_t* data);


// Checks for out of range values in the rear damper displacement, results in 
// warning protocol to USB, log file, and LEDs
// Requires either rear damper displacement data from CAN bus
void checkRangeDamperR(uint8_t* data);


// Checks for out of range values in the steering wheel hand clutch, results in 
// error protocol to USB, log file, and LEDs
// Requires hand clutch displacement data from CAN bus
void checkRangeHandClutch(uint8_t* data);


// Checks for out of range values in the steering angle, results in warning
// protocol to USB, log file, and LEDs
// Requires steering angle data from CAN bus
void checkRangeSteeringAngle(uint8_t* data);


// Checks for implausibility in front wheel speed values, results in warning
// protocol to USB, log file, and LEDs
// Requires front left and right wheel speed values
void checkImplausibilityWheelSpeedF(float wheelSpeedFL, float wheelSpeedFR);


// Checks for implausibility in rear wheel speed values, results in warning
// protocol to USB, log file, and LEDs
// Requires rear left and right wheel speed values
void checkImplausibilityWheelSpeedR(float wheelSpeedRL, float wheelSpeedRR);


#endif  // HEALTH_CHECK_H_