#include "mbed.h"
#include "rtos.h"
#include "notes.h"
#include "math.h"
#include "wii.h"

Serial pc(USBTX, USBRX); // tx, rx
class Flipper {
public:
    Flipper(PinName pin) : _pin(pin) {
        _pin = 0;
    }
    void flip() {
        _pin = !_pin;
    }
private:
    DigitalOut _pin;
};
 
DigitalOut led1(LED1);
Flipper f1(p21);
Flipper f2(p22);
Flipper f3(p23);
Ticker t1;
Ticker t2;
Ticker t3;

Mutex motor1lock;
Mutex motor2lock;
Mutex motor3lock;
Timer motor1timer;

/*
Takes the midi number in from the array and then converts it to a frequency in hz;
*/
float midi2freq(float midi){
    return 440.0*powf(2.0, (midi-69)/12);
}

/*
Stops playback for motor1 and unlocks it to allow a new note to be set
*/
void stopMotor1(){
    motor1lock.unlock();
    }
int main() {
    //parse length here
    int length = (int)( sizeof(noteswii) / sizeof(noteswii[0]));
    // copy above for more lines of notes
    
    //parsing of notes, needs to partse 
    
    //parsing of durs
    
    

    pc.printf("Hello World!\n");
    motor1timer.start();
    // spin in a main loop. flipper will interrupt it to call flip
    while(1) {
        for(int i = 0; i < length;) {
        //This sees if we ever have an unlocked motor lock,
        //in which case the motor will be done playing and
        //we will need to set it to silent
        if(motor1lock.trylock()){
            motor1lock.unlock(); //Make the motor available for note commands
            t1.detach();  //Stop the ticker on the motor
            }
        if(motor2lock.trylock()){
            motor2lock.unlock();
            t2.detach(); 
            }
        if(motor3lock.trylock()){
            motor3lock.unlock();
            t3.detach(); 
            }   
            
            /*
            IF THIS IS TRUE it means we have a note that just came into 
            being played and we should move through the indexed list
            at the very end
            */         
        if(notesstart[i]<motor1timer.read()){
            if(motor1lock.trylock_for((notesstop[i]-notesstart[i]*1000)) { //This means we were succesfully able to lock the motor
                t1.attach(&f1, &Flipper::flip, 1.0/midi2freq(noteswii[i]));
                }
                
         
         
         i++;//THIS NEEDS TO BE THE LAST THING   
        }
        else {
        t1.attach(&f1, &Flipper::flip, 1.0/notes1[i]); }
        pc.printf("%f\n",notes1[i]);
        pc.printf("%f\n",durs1[i]);
        wait(durs1[i]);
        pc.printf("The timer is at %f\n\n", motor1timer.read());
        }
        
    }
}