#include "mbed.h"
#include "PinDetect.h"

//hardware declarations
Serial pc(USBTX, USBRX);
Serial esp(p13, p14);
Serial gps(p28, p27);
BusOut status(LED4, LED3, LED2, LED1);
PinDetect interrupt(p21);

//global variables
unsigned long tripid;
int button_signal;
int on_trip;

//golbals for Serial communication
char snd[1500];
char buf[1024];
Timer t;
int timeout = 1;
int ended, count2;

//functions
void button_press(void);
void start_trip(void);
void setup(void);
void get_reply(void);

void button_press(void) {
    button_signal = 1;   
}

void start_trip(void) {
    if (on_trip) {
        sprintf(snd, "http.get(\"http://ece4180.sousys.com/home/endtrip/%d/\", nil, function(code, data) print(data) end)\r\n", tripid);
        on_trip = 0;
    } else {
        ++tripid;
        strcpy(snd, "http.get(\"http://ece4180.sousys.com/home/startnewtrip/100/\", nil, function(code, data) print(data) end)\r\n");
        on_trip = 1;
    }    
    esp.printf("%s", snd);
    timeout = 1;
    get_reply();
    char* response = strchr(buf + 1, '>') + 2; //get pointer to data after 2nd '>' char
    tripid = atoi(response);                   //format is '>', then ' ', then response
    pc.printf("%lu", tripid);                 
    button_signal = 0;
    printf("on_trip: %d\r\n", on_trip);
}

void setup(void) {
    status = 14;
    timeout = 1;
    strcpy(snd, "node.restart()\r\n");
    esp.printf("%s", snd);
    get_reply();
    wait(.1);
    strcpy(snd, "wifi.setmode(wifi.STATION)\r\n");
    esp.printf("%s", snd);
    timeout=2;
    get_reply();
    wait(.1);
    strcpy(snd, "station_cfg={}\r\n"); 
    esp.printf("%s", snd);
    get_reply();
    wait(.1);   
    sprintf(snd, "station_cfg.ssid=\"%s\"\r\n", "iPhone");
    esp.printf("%s", snd);
    get_reply();
    wait(.1);
    sprintf(snd, "station_cfg.pwd=\"%s\"\r\n", "ece4180wifi"); 
    timeout = 3;
    esp.printf("%s", snd);
    get_reply();
    wait(.1);   
    sprintf(snd, "wifi.sta.config(station_cfg)\r\n");   
    esp.printf("%s", snd);
    get_reply();
    wait(.1);
    strcpy(snd, "wifi.sta.connect()\r\n");
    esp.printf("%s", snd);
    timeout = 5;
    get_reply();
    wait(2); 
    
    strcpy(snd, "print(wifi.sta.getip())\r\n");
    esp.printf("%s", snd);
    timeout=5;
    get_reply();
    wait(.1); 
    
    strcpy(snd, "print(wifi.sta.status())\r\n");
    esp.printf("%s", snd);
    get_reply();
    wait(.1);
}

void get_reply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count2=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count2++] = esp.getc();
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
    pc.printf("%s", buf);
}

int main() {
    pc.baud(115200);
    esp.baud(115200);
    //setup();
    
    interrupt.mode(PullUp);
    wait(.1);
    interrupt.attach_deasserted(&button_press);
    interrupt.setSampleFrequency();
    char* response;
    do {
        status = 4;
        strcpy(snd, "http.get(\"http://checkip.amazonaws.com\", nil, function(code, data) print(data) end)\r\n");
        esp.printf("%s", snd);
        timeout = 1;
        get_reply();
        wait(.1);
        response = strchr(buf + 1, '>') + 2;        //get pointer to data after 2nd '>' char
        pc.printf("%s", response);                  //format is '>', then ' ', then response
    } while (!(response[0] >= '0' && response[0] <= '9'));
    while (!gps.readable()) {status = 12;}
    pc.printf("ready\r\n");
    status = 15;
    char cDataBuffer[500];
    char c;
    on_trip = 0;
    
    while(1) {
        if (button_signal) {
            start_trip();
        }
        if(on_trip && gps.readable()) {
            if(gps.getc() == '$'); {
                for(int i=0; i<sizeof(cDataBuffer); i++) {
                    c = gps.getc();
                    if( c == '\r' ) {
                        char ns, ew, status;
                        int date;
                        float latitude, longitude, timefix, speed;
                        
                        // Geographic position, Latitude and Longitude
                        if(strncmp(cDataBuffer,"$GPRMC", 6) == 0) {
                            sscanf(cDataBuffer, "$GPRMC,%f,%c,%f,%c,%f,%c,%f,,%d", &timefix, &status, &latitude, &ns, &longitude, &ew, &speed, &date);
                            //convert to decimal degrees
                            int latdeg = ((int) latitude) / 100;
                            float latmin = latitude - (latdeg * 100);
                            latitude = latdeg + (latmin / 60);
                            int londeg = ((int) longitude) / 100;
                            float lonmin = longitude - (londeg * 100);
                            longitude = londeg + (lonmin / 60);
                            pc.printf("tripid: %lu\r\nlatitude: %f\r\nlongitude: %f\r\n", tripid, latitude, longitude);
                            if (latitude > 1 && longitude > 1) {
                                status = 10;
                                if (ns == 'S') latitude *= -1;
                                if (ew == 'W') longitude *= -1;    
                                sprintf(snd, "http.get(\"http://ece4180.sousys.com/realtime/uploadposition/%d/%f/%f\", nil, function(code, data) print(data) end)\r\n", tripid, latitude, longitude);
                                pc.printf("%s", snd);
                                esp.printf("%s", snd);
                                timeout = 1;
                                get_reply();
                            } else {
                                status = 7;   
                            }
                            wait(.5);
                        }
                        i = sizeof(cDataBuffer);
                    } else {
                        cDataBuffer[i] = c;
                    }                 
                }
            }
        }
    }
}