#include "mbed.h"
#include "WS2812.h"
#include "PixelArray.h"
#include "C12832_lcd.h"

#define WS2812_BUF 3
#define NUM_COLORS 9
#define NUM_LEDS_PER_COLOR 3
PixelArray px(WS2812_BUF);

// See the program page for information on the timing numbers
// The given numbers are for the K64F
WS2812 ws(p9, WS2812_BUF, 5, 10, 10, 15);

//LCD Setup
C12832_LCD lcd;  

Serial pc(USBTX, USBRX); // tx, rx

void LED_Colour(int red , int green ,int blue , int bright)
    {
    int colorbuf[NUM_COLORS] = {0x000000};
    //int colorbuf[NUM_COLORS] = {0x000000,0x00f0ff,0x00ff00,0x00ffff,0xffffff,0x00ff00,0x00ffff,0x0000ff,0xff00ff};
    
    colorbuf[0] = red*0xffff + green*0xff + blue*0x00;
    
    pc.printf("Colour: %x \n\r",colorbuf[0]);
    // for each of the colours (j) write out 10 of them
    // the pixels are written at the colour*10, plus the colour position
    // all modulus 60 so it wraps around
    for (int i = 0; i < WS2812_BUF; i++) {
        px.Set(i, colorbuf[(i / NUM_LEDS_PER_COLOR) % NUM_COLORS]);
    }

    // now all the colours are computed, add a fade effect using intensity scaling
    // compute and write the II value for each pixel
    for (int j=0; j<WS2812_BUF; j++) {
        // px.SetI(pixel position, II value)
        //px.SetI(j%WS2812_BUF, 0xff+(0xf*(j%NUM_LEDS_PER_COLOR)));     //full brightness
        px.SetI(j%WS2812_BUF, 0xf +(0xf*(j%NUM_LEDS_PER_COLOR)));        //Dim lighting
    }       
}
int main()
{

    ws.useII(WS2812::PER_PIXEL); // use per-pixel intensity scaling
    
     while (1) {
 
        LED_Colour(125, 125 ,125 , 125);
        wait(1);
        }
}
