#include "mbed.h"
#include "rtos.h"
#include "C12832.h"                                     // Include the LCD header files 

C12832 lcd(p5, p7, p6, p8, p11);                        //Initialise LCD

DigitalIn Up(p15);                                      //Initialise Joystick up
DigitalIn Down(p12);                                    //Initialise Joystick down
DigitalIn Left(p13);                                    //Initialise Joystick left
DigitalIn Right(p16);                                   //Initialise Joystick right


AnalogIn Pot1(p19);                                     //Initialise Pot1 to be an analog input
AnalogIn Pot2(p20);                                     //Initialise Pot2 to be an analog input

PwmOut LED_1(p25);                                      //Initialise Blue
PwmOut LED_2(p24);                                      //Initialise Green
PwmOut LED_3(p23);                                      //Initialise Red

PwmOut spkr(p26);                                       //Initialise PWM to speaker

typedef struct                                          //Initialise Sturture
{
    float   Joystick;                                   //Set Joystick as a float
    float   Light;                                      //Set Light as a float
    float   Pot1_Value;                                 //Initialise Red
    float   Pot2_Value;                                 //Initialise Red

} message_t;                                            //Sturecture name "message_t"



MemoryPool<message_t, 16> mpool;                        //Allocate a Mpool of value 16
Queue<message_t, 16> queue;                             //Allocate a Queue of value 16


void Send (void const *args)                            //Setup the thread function
{

    while (true)                                        //Super loop
    {
        if (Up == 1)                                    //When Joystick is a value of 1 (Pushed up)
        {
        message_t *message = mpool.alloc();             //allocate memory 
        message->Joystick = 1;                          //Set message will be the Joystick Value 1
        message->Light = 1;                             //The message will be the Light Value 1
        message->Pot1_Value = Pot1;                     //Read Pot1 and store in message->Pot1_Value
        message->Pot2_Value = Pot2;                     //Read Pot2 and store in message->Pot2_Value
        queue.put(message);                             //Place it in the Queue
        Thread::wait(500);                              //Thread wait for 500 msec
         }   
         
        else if (Down == 1)                                     //When Joystick is a value of 1 (Pushed up)
        {
        message_t *message = mpool.alloc();
        message->Joystick = 2;                          //Set message will be the Joystick Value 2
        message->Light = 2;                             //The message will be the Light Value 2
        message->Pot1_Value = Pot1;                     //Read Pot1 and store in message->Pot1_Value
        message->Pot2_Value = Pot2;                     //Read Pot2 and store in message->Pot2_Value
        queue.put(message);                             //Place it in the Queue
        Thread::wait(500);                              //Thread wait for 500 msec
        }  
          
        else if (Left == 1)                             //When Joystick is a value of 1 (Pushed up)
        {
        message_t *message = mpool.alloc();
        message->Joystick = 4;                          //Set message will be the Joystick Value 4
        message->Light = 3;                             //The message will be the Light Value 3
        message->Pot1_Value = Pot1;                     //Read Pot1 and store in message->Pot1_Value
        message->Pot2_Value = Pot2;                     //Read Pot2 and store in message->Pot2_Value
        queue.put(message);                             //Place it in the Queue
        Thread::wait(500);                              //Thread wait for 500 msec 
        }
            
        else if (Right == 1)                            //When Joystick is a value of 1 (Pushed up)
        {
        message_t *message = mpool.alloc();
        message->Joystick = 3;                          //Set message will be the Joystick Value 3
        message->Light = 4;                             //The message will be the Light Value 4
        message->Pot1_Value = Pot1;                     //Read Pot1 and store in message->Pot1_Value
        message->Pot2_Value = Pot2;                     //Read Pot2 and store in message->Pot2_Value      
        queue.put(message);                             //Place it in the Queue
        Thread::wait(500);                              //Thread wait for 500 msec  
        }


    }
}

int main (void) 
{
    LED_1 = 1;                                          //Turn off R
    LED_2 = 1;                                          //Turn off B
    LED_3 = 1;                                          //Turn off G
    
    Thread thread(Send);                                //Start up tread for send

    
    while (true) 
    {
        osEvent evt = queue.get();                      //Get next queue
        if (evt.status == osEventMessage)               
        {
            message_t *message = (message_t*)evt.value.p;                           //ppinter in the queue
            lcd.cls();                                                              // clear screen of the lcd
            lcd.locate(0,3);                                                        //set location on the LCD
            lcd.printf("Joystick Value: %.2f \n\r"   , message->Joystick);          //display joystick value on LCD
            lcd.printf("Light Value: %.2f \n\r"     , message->Light);              //display Light value on LCD
            lcd.printf("Pot1:%.2f Pot2:%.4f\n\r"     , message->Pot1_Value, message->Pot2_Value);   //display Pot1 & Pot2 value on LCD
            
            
            if (message->Light == 1)                    // When message is value 1 display Light sequence
            {
             LED_1 = message->Pot1_Value;               // dim the Blue LED with the value in pot1
             LED_2 = 1;                                 //Turn off LED
             LED_3 = 1;                                 //Turn off LED
             spkr = message->Pot2_Value;                // dim the Blue LED with the value in pot1
            }
            else if (message->Light == 2)
            {
             LED_1 = 1;                                 //Turn off LED
             LED_2 = message->Pot1_Value;               // dim the Green LED with the value in pot1
             LED_3 = 1;                                 //Turn off LED
             spkr = message->Pot2_Value;                // dim the Blue LED with the value in pot1
            }
            else if (message->Light == 3)
            {
             LED_1 = 1;                                 //Turn off LED
             LED_2 = 1;                                 //Turn off LED
             LED_3 = message->Pot1_Value;               // dim the Red LED with the value in pot1
             spkr = message->Pot2_Value;
            }            
            else if (message->Light == 4)
            {
             LED_1 = message->Pot1_Value;               // dim the Blue LED with the value in pot1
             LED_2 = message->Pot1_Value;               // dim the Green LED with the value in pot1
             LED_3 = 1;                                 //Turn off LED
             spkr = message->Pot2_Value;                // dim the Blue LED with the value in pot1
            }
            
            mpool.free(message);                        // Frees up memory
        }
    }
}