#include "mbed.h"
#include "rtos.h"

PwmOut led(p25);                            //setup LED for PWM

void led_thread(void const *argument) {
    while (true) {
        // Signal flags that are reported as event are automatically cleared.
        Thread::signal_wait(0x2);           //Wait for flag to be set after thread wait for 2000 msec
        led = 0.5;                          //dim LED to half brightness
        Thread::signal_wait(0x1);           //Wait for flag to be set after thread wait for 100 msec
        led = 1;                            //turn off LED
    }
}

int main (void) {
    Thread thread(led_thread);              //start thread
    
    while (true) {
        Thread::wait(1000);                 //thread wait for 1000 msec
        thread.signal_set(0x1);             //set the flag for "0x1"
        Thread::wait(2000);                 //Thread wait for 2000 msec
        thread.signal_set(0x2);             //set the flag for "0x2
    }
}
