#include "mbed.h"                               //Include the mbed.h file   
#include "rtos.h"                               //include the RTOS.h file
#include "LM75B.h"                              //include the LM75B.h file
#include "C12832.h"                             //include the C12832.h file

C12832 lcd(p5, p7, p6, p8, p11);                //Setup the LCD

LM75B sensor(p28,p27);                          //Setup the Temp Sensor I2C
Serial pc(USBTX,USBRX);                         //Setup the serial comm

float Temp_Value;                               //global var for temp
     
PwmOut spkr(p26);                               //PWM speaker
PwmOut LED_red(p23);                            //PWM LED red
PwmOut LED_blue(p25);                           //PWM LED blue
        
DigitalOut led1(LED1);                          //Setup LED1 to the varible name led1
DigitalOut led2(LED2);                          //Setup LED2 to the varible name led2

Mutex Temp_Mutex;                               //Setup Mutex
 
 
void Tempature_Senor(void const *args) {        //Function or the thread to be called

     
    if (sensor.open()) {                        //Try to open the LM75B
        printf("Device detected!\n");           //printf if device connects

        while (1) {
            lcd.cls();                          //Clears LCD
            lcd.locate(0,3);                    //Locartion on LCD display
            Temp_Mutex.lock();                  //Mutex Lock sensor
            lcd.printf("Temp = %.3f\n", (float)sensor); //Print Temp value on LCD
            Temp_Value = (float)sensor;         //read sonsor and store in Temp_value
            Temp_Mutex.unlock();                //Mutex unlock sensor
            Thread::wait(1.0);                  //Thread wait
        }

    } else {
        error("Device not detected!\n");        //Printf on serial if error
    }                                           //End Super loop
}  
 
void Speaker(void const *args) {                //Function or the thread to be called
    while (true) {                              //Super loop
        spkr.period(1.0/5000);                  //set period        
        spkr = 0.25;                            //set PWM      
        Thread::wait(800);                      //Thread wait
        spkr.period(1.0/3000);                  //set period 
        spkr = 0.25;                            //set PWM 
        Thread::wait(800);                      //Thread wait            
    }                                           //End Super loop
}  
 
void led_R_B_flash(void const *args) {          //Function or the thread to be called
    while (true) {                              //Super loop
    
        LED_red = 0.5;                          //PWM LED to half brightness
        LED_blue = 1;                           //Turn blue LED off
        Thread::wait(800); 
        LED_red = 1;                            //Turn red LED off   
        LED_blue = 0.5;                         //PWM LED to half brightness                       
        Thread::wait(800);                      //Thread wait
    }                                           //End Super loop
}                                               //End Function / thread
 
int main() {                                    //Main
    float local_Temp_V=0;                       //SETup local var
    Thread thread_Temp(Tempature_Senor);        //start thread
    Thread thread_LED_Flash(led_R_B_flash);     //start thread      
    Thread thread_Speaker_Sound(Speaker);       //start thread
    
        while (1) {
            Temp_Mutex.lock();                  //Mutex lock temp value
            local_Temp_V = Temp_Value;          //store temp value in local variable
            Temp_Mutex.unlock();                //mutex unlock
            printf("Temp = %.3f\n", local_Temp_V );     //printf on serial of local temp value       
            Thread::wait(1.0);                  //thread wait
        }

    
}                                       //End main
