#include <mbed.h>
#include <terminus.h>

const char TerminusFontBitmaps[] = {
    // #32
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // ' '
    0x00,0x00,0x20,0x20,0x20,0x20,0x20,0x00,0x20,0x20,0x00,0x00, // '!'
    0x00,0x50,0x50,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '"'
    0x00,0x00,0x50,0x50,0xF8,0x50,0x50,0xF8,0x50,0x50,0x00,0x00, // '#'
//******************************************************new    
   // 0x00,0x00,0x50,0x50,0x88,0x88,0x88,0x88,0x88,0x78,0x00,0x00, // 'ü' '\xFC'  '$' verwenden für 'ü'
//**********************************************************    
    0x00,0x00,0x20,0x70,0xA8,0xA0,0x70,0x28,0xA8,0x70,0x20,0x00, // '$'
    0x00,0x00,0x48,0xA8,0x50,0x10,0x20,0x28,0x54,0x48,0x00,0x00, // '%'
    0x00,0x00,0x20,0x50,0x50,0x20,0x68,0x90,0x90,0x68,0x00,0x00, // '&'
    0x00,0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '''
    0x00,0x00,0x10,0x20,0x40,0x40,0x40,0x40,0x20,0x10,0x00,0x00, // '('
    0x00,0x00,0x40,0x20,0x10,0x10,0x10,0x10,0x20,0x40,0x00,0x00, // ')'
    0x00,0x00,0x00,0x00,0x50,0x20,0xF8,0x20,0x50,0x00,0x00,0x00, // '*'
    0x00,0x00,0x00,0x00,0x20,0x20,0xF8,0x20,0x20,0x00,0x00,0x00, // '+'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x40,0x00, // ','
    0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00, // '-'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x00,0x00, // '.'
    0x00,0x00,0x08,0x08,0x10,0x10,0x20,0x20,0x40,0x40,0x00,0x00, // '/'
    0x00,0x00,0x70,0x88,0x98,0xA8,0xC8,0x88,0x88,0x70,0x00,0x00, // '0'
    0x00,0x00,0x20,0x60,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // '1'
    0x00,0x00,0x70,0x88,0x88,0x10,0x20,0x40,0x80,0xF8,0x00,0x00, // '2'
    0x00,0x00,0x70,0x88,0x08,0x30,0x08,0x08,0x88,0x70,0x00,0x00, // '3'
    0x00,0x00,0x08,0x18,0x28,0x48,0x88,0xF8,0x08,0x08,0x00,0x00, // '4'
    0x00,0x00,0xF8,0x80,0x80,0xF0,0x08,0x08,0x88,0x70,0x00,0x00, // '5'
    0x00,0x00,0x70,0x80,0x80,0xF0,0x88,0x88,0x88,0x70,0x00,0x00, // '6'
    0x00,0x00,0xF8,0x08,0x08,0x10,0x10,0x20,0x20,0x20,0x00,0x00, // '7'
    0x00,0x00,0x70,0x88,0x88,0x70,0x88,0x88,0x88,0x70,0x00,0x00, // '8'
    0x00,0x00,0x70,0x88,0x88,0x88,0x78,0x08,0x08,0x70,0x00,0x00, // '9'
    0x00,0x00,0x00,0x00,0x20,0x20,0x00,0x00,0x20,0x20,0x00,0x00, // ':'
    0x00,0x00,0x00,0x00,0x20,0x20,0x00,0x00,0x20,0x20,0x40,0x00, // ';'
    0x00,0x00,0x00,0x08,0x10,0x20,0x40,0x20,0x10,0x08,0x00,0x00, // '<'
    0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00,0x00,0x00, // '='
    0x00,0x00,0x00,0x40,0x20,0x10,0x08,0x10,0x20,0x40,0x00,0x00, // '>'
    0x00,0x00,0x70,0x88,0x88,0x10,0x20,0x00,0x20,0x20,0x00,0x00, // '?'
    0x00,0x00,0x70,0x88,0x98,0xA8,0xA8,0x98,0x80,0x78,0x00,0x00, // '@'
    0x00,0x00,0x70,0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00,0x00, // 'A'
    0x00,0x00,0xF0,0x88,0x88,0xF0,0x88,0x88,0x88,0xF0,0x00,0x00, // 'B'
    0x00,0x00,0x70,0x88,0x80,0x80,0x80,0x80,0x88,0x70,0x00,0x00, // 'C' '\x43'
    0x00,0x00,0xE0,0x90,0x88,0x88,0x88,0x88,0x90,0xE0,0x00,0x00, // 'D'
    0x00,0x00,0xF8,0x80,0x80,0xF0,0x80,0x80,0x80,0xF8,0x00,0x00, // 'E'
    0x00,0x00,0xF8,0x80,0x80,0xF0,0x80,0x80,0x80,0x80,0x00,0x00, // 'F' '\x46'
    0x00,0x00,0x70,0x88,0x80,0x80,0xB8,0x88,0x88,0x70,0x00,0x00, // 'G'
    0x00,0x00,0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x88,0x00,0x00, // 'H'
    0x00,0x00,0x70,0x20,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // 'I'
    0x00,0x00,0x38,0x10,0x10,0x10,0x10,0x90,0x90,0x60,0x00,0x00, // 'J'
    0x00,0x00,0x88,0x90,0xA0,0xC0,0xC0,0xA0,0x90,0x88,0x00,0x00, // 'K'
    0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xF8,0x00,0x00, // 'L'
    0x00,0x00,0x88,0xD8,0xA8,0xA8,0x88,0x88,0x88,0x88,0x00,0x00, // 'M'
    0x00,0x00,0x88,0x88,0xC8,0xA8,0x98,0x88,0x88,0x88,0x00,0x00, // 'N'
    0x00,0x00,0x70,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'O'
    0x00,0x00,0xF0,0x88,0x88,0x88,0xF0,0x80,0x80,0x80,0x00,0x00, // 'P'
    0x00,0x00,0x70,0x88,0x88,0x88,0x88,0x88,0xA8,0x70,0x08,0x00, // 'Q'
    0x00,0x00,0xF0,0x88,0x88,0x88,0xF0,0xA0,0x90,0x88,0x00,0x00, // 'R'
    0x00,0x00,0x70,0x88,0x80,0x70,0x08,0x08,0x88,0x70,0x00,0x00, // 'S'
    0x00,0x00,0xF8,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x00, // 'T'
    0x00,0x00,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'U'
    0x00,0x00,0x88,0x88,0x88,0x50,0x50,0x50,0x20,0x20,0x00,0x00, // 'V'
    0x00,0x00,0x88,0x88,0x88,0x88,0xA8,0xA8,0xD8,0x88,0x00,0x00, // 'W'
    0x00,0x00,0x88,0x88,0x50,0x20,0x20,0x50,0x88,0x88,0x00,0x00, // 'X'
    0x00,0x00,0x88,0x88,0x50,0x50,0x20,0x20,0x20,0x20,0x00,0x00, // 'Y'
    0x00,0x00,0xF8,0x08,0x10,0x20,0x40,0x80,0x80,0xF8,0x00,0x00, // 'Z'
    0x00,0x00,0x70,0x40,0x40,0x40,0x40,0x40,0x40,0x70,0x00,0x00, // '['
    0x00,0x00,0x40,0x40,0x20,0x20,0x10,0x10,0x08,0x08,0x00,0x00, // '\'
    0x00,0x00,0x70,0x10,0x10,0x10,0x10,0x10,0x10,0x70,0x00,0x00, // ']'
    0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '^'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00, // '_'
    0x40,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '`'
    0x00,0x00,0x00,0x00,0x70,0x08,0x78,0x88,0x88,0x78,0x00,0x00, // 'a'
    0x00,0x00,0x80,0x80,0xF0,0x88,0x88,0x88,0x88,0xF0,0x00,0x00, // 'b'
    0x00,0x00,0x00,0x00,0x70,0x88,0x80,0x80,0x88,0x70,0x00,0x00, // 'c'
    0x00,0x00,0x08,0x08,0x78,0x88,0x88,0x88,0x88,0x78,0x00,0x00, // 'd'
    0x00,0x00,0x00,0x00,0x70,0x88,0xF8,0x80,0x88,0x70,0x00,0x00, // 'e'
    0x00,0x00,0x18,0x20,0x70,0x20,0x20,0x20,0x20,0x20,0x00,0x00, // 'f'
    0x00,0x00,0x00,0x00,0x78,0x88,0x88,0x88,0x88,0x78,0x08,0x70, // 'g'
    0x00,0x00,0x80,0x80,0xF0,0x88,0x88,0x88,0x88,0x88,0x00,0x00, // 'h'
    0x00,0x20,0x20,0x00,0x60,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // 'i'
    0x00,0x08,0x08,0x00,0x18,0x08,0x08,0x08,0x08,0x08,0x48,0x30, // 'j'
    0x00,0x00,0x40,0x40,0x48,0x50,0x60,0x60,0x50,0x48,0x00,0x00, // 'k'
    0x00,0x00,0x60,0x20,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // 'l'
    0x00,0x00,0x00,0x00,0xF0,0xA8,0xA8,0xA8,0xA8,0xA8,0x00,0x00, // 'm'
    0x00,0x00,0x00,0x00,0xF0,0x88,0x88,0x88,0x88,0x88,0x00,0x00, // 'n'
    0x00,0x00,0x00,0x00,0x70,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'o'
    0x00,0x00,0x00,0x00,0xF0,0x88,0x88,0x88,0x88,0xF0,0x80,0x80, // 'p'
    0x00,0x00,0x00,0x00,0x78,0x88,0x88,0x88,0x88,0x78,0x08,0x08, // 'q'
    0x00,0x00,0x00,0x00,0xB8,0xC0,0x80,0x80,0x80,0x80,0x00,0x00, // 'r'
    0x00,0x00,0x00,0x00,0x78,0x80,0x70,0x08,0x08,0xF0,0x00,0x00, // 's'
    0x00,0x00,0x20,0x20,0x70,0x20,0x20,0x20,0x20,0x18,0x00,0x00, // 't'
    0x00,0x00,0x00,0x00,0x88,0x88,0x88,0x88,0x88,0x78,0x00,0x00, // 'u'
    0x00,0x00,0x00,0x00,0x88,0x88,0x50,0x50,0x20,0x20,0x00,0x00, // 'v'
    0x00,0x00,0x00,0x00,0x88,0x88,0xA8,0xA8,0xA8,0x70,0x00,0x00, // 'w'
    0x00,0x00,0x00,0x00,0x88,0x50,0x20,0x20,0x50,0x88,0x00,0x00, // 'x'
    0x00,0x00,0x00,0x00,0x88,0x88,0x88,0x88,0x88,0x78,0x08,0x70, // 'y'
    0x00,0x00,0x00,0x00,0xF8,0x10,0x20,0x40,0x80,0xF8,0x00,0x00, // 'z'
    0x00,0x00,0x18,0x20,0x20,0x40,0x20,0x20,0x20,0x18,0x00,0x00, // '{'
    0x00,0x00,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x00, // '|'
    0x00,0x00,0x60,0x10,0x10,0x08,0x10,0x10,0x10,0x60,0x00,0x00, // '}'
    // #126
    0x00,0x48,0xA8,0x90,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '~'
    // #128
    0x00,0x0C,0x16,0x20,0x60,0xFC,0x60,0xF8,0x10,0x0C,0x00,0x00, // '€' '\x80'
    // #139
    0x00,0x00,0x00,0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x00,0x00, // '‹' '\x8B'
    // #155
    0x00,0x00,0x00,0x20,0x10,0x08,0x04,0x08,0x10,0x20,0x00,0x00, // '›' '\x9B'
    // #160
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '' (&nbsp;) '\xA0'
    /******************************************************************************/
    // Zeichen mit Hexcode 0xA1 - 0xA6 durch Umlaute ersetzt, da bestimmte Umlaute mit
    // hohem Hexcodewert wie 'ü' =  0xFC nicht richtig dargestellet werden
    
    0x50,0x50,0x70,0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00,0x00, // 'Ä' '\xA1' '\241'
    0x50,0x50,0x70,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'Ö' '\xA2' '\242' 
    0x50,0x50,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'Ü' '\xA3' '\243' 
    0x00,0x00,0x50,0x50,0x70,0x08,0x78,0x88,0x88,0x78,0x00,0x00, // 'ä' '\xA4' '\244'
    0x00,0x00,0x50,0x50,0x70,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'ö' '\xA5' '\245'
    0x00,0x00,0x50,0x50,0x88,0x88,0x88,0x88,0x88,0x78,0x00,0x00, // 'ü' '\xA6' '\246'
   
    /******************************************************************************/ 
    //0x00,0x00,0x20,0x20,0x00,0x20,0x20,0x20,0x20,0x20,0x00,0x00, // '¡' '\xA1'
    //0x00,0x00,0x00,0x20,0x70,0xA8,0xA0,0xA0,0xA8,0x70,0x20,0x00, // '¢' '\xA2'
    //0x00,0x00,0x30,0x48,0x40,0xF0,0x40,0x40,0x48,0xF8,0x00,0x00, // '£' '\xA3'
    //0x00,0x00,0x00,0x48,0x30,0x48,0x48,0x30,0x48,0x00,0x00,0x00, // '¤' '\xA4'
    //0x00,0x00,0x88,0x88,0x50,0x20,0x70,0x20,0x70,0x20,0x00,0x00, // '¥' '\xA5'
    //0x00,0x00,0x20,0x20,0x20,0x00,0x00,0x20,0x20,0x20,0x00,0x00, // '¦' '\xA6'
    0x00,0x30,0x48,0x20,0x50,0x48,0x28,0x10,0x48,0x30,0x00,0x00, // '§' '\xA7'
    0x50,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¨' '\xA8'
    0x00,0x00,0x78,0x84,0xB4,0xA4,0xA4,0xB4,0x84,0x78,0x00,0x00, // '©' '\xA9'
    0x30,0x08,0x38,0x48,0x38,0x00,0x78,0x00,0x00,0x00,0x00,0x00, // 'ª' '\xAA'
    0x00,0x00,0x00,0x14,0x28,0x50,0xA0,0x50,0x28,0x14,0x00,0x00, // '«' '\xAB'
    0x00,0x00,0x00,0x00,0xF8,0x08,0x08,0x08,0x00,0x00,0x00,0x00, // '¬' '\xAC'
    0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00, // '­ ­­­­' '\xAD'
    0x00,0x00,0x78,0x84,0xB4,0xAC,0xB4,0xAC,0x84,0x78,0x00,0x00, // '®' '\xAE'
    0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¯' '\xAF'
    0x00,0x20,0x50,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '°' '\xB0'
    0x00,0x00,0x00,0x20,0x20,0xF8,0x20,0x20,0x00,0xF8,0x00,0x00, // '±' '\xB1'
    0x00,0x30,0x48,0x10,0x20,0x78,0x00,0x00,0x00,0x00,0x00,0x00, // '²' '\xB2'
    0x00,0x70,0x08,0x30,0x08,0x70,0x00,0x00,0x00,0x00,0x00,0x00, // '³' '\xB3'
    0x10,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '´' '\xB4'
    0x00,0x00,0x00,0x00,0x88,0x88,0x88,0x88,0x98,0xE8,0x80,0x80, // 'µ' '\xB5'
    0x00,0x00,0x78,0xA8,0xA8,0xA8,0x68,0x28,0x28,0x28,0x00,0x00, // '¶' '\xB6'
    0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x00,0x00,0x00,0x00,0x00, // '·' '\xB7'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x40, // '¸' '\xB8'
    0x00,0x20,0x60,0x20,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¹' '\xB9'
    0x30,0x48,0x48,0x48,0x30,0x00,0x78,0x00,0x00,0x00,0x00,0x00, // 'º' '\xBA'
    0x00,0x00,0x00,0xA0,0x50,0x28,0x14,0x28,0x50,0xA0,0x00,0x00, // '»' '\xBB'
    0x40,0xC0,0x40,0x48,0x10,0x20,0x48,0x98,0x28,0x78,0x08,0x08, // '¼' '\xBC'
    0x40,0xC0,0x44,0x48,0x10,0x20,0x40,0x98,0x24,0x08,0x10,0x3C, // '½' '\xBD'
    0xC0,0x20,0xC0,0x24,0xC8,0x10,0x24,0x4C,0x94,0x3C,0x04,0x04, // '¾' '\xBE'
    0x00,0x00,0x20,0x20,0x00,0x20,0x40,0x88,0x88,0x70,0x00,0x00, // '¿' '\xBF'
    0x40,0x20,0x70,0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00,0x00, // 'À' '\xC0'
    0x10,0x20,0x70,0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00,0x00, // 'Á' '\xC1'
    0x20,0x50,0x70,0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00,0x00, // 'Â' '\xC2'
    0x28,0x50,0x70,0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00,0x00, // 'Ã' '\xC3'
    0x50,0x50,0x70,0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00,0x00, // 'Ä' '\xC4'
    0x20,0x50,0x70,0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00,0x00, // 'Å' '\xC5'
    0x00,0x00,0x7C,0x90,0x90,0xFC,0x90,0x90,0x90,0x9C,0x00,0x00, // 'Æ' '\xC6'
    0x00,0x00,0x70,0x88,0x80,0x80,0x80,0x80,0x88,0x70,0x20,0x40, // 'Ç' '\xC7'
    0x40,0x20,0xF8,0x80,0x80,0xF0,0x80,0x80,0x80,0xF8,0x00,0x00, // 'È' '\xC8'
    0x10,0x20,0xF8,0x80,0x80,0xF0,0x80,0x80,0x80,0xF8,0x00,0x00, // 'É' '\xC9'
    0x20,0x50,0xF8,0x80,0x80,0xF0,0x80,0x80,0x80,0xF8,0x00,0x00, // 'Ê' '\xCA'
    0x50,0x50,0xF8,0x80,0x80,0xF0,0x80,0x80,0x80,0xF8,0x00,0x00, // 'Ë' '\xCB'
    0x40,0x20,0x70,0x20,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // 'Ì' '\xCC'
    0x10,0x20,0x70,0x20,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // 'Í' '\xCD'
    0x20,0x50,0x70,0x20,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // 'Î' '\xCE'
    0x50,0x50,0x70,0x20,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // 'Ï' '\xCF'
    0x00,0x00,0xE0,0x90,0x88,0xE8,0x88,0x88,0x90,0xE0,0x00,0x00, // 'Ð' '\xD0'
    0x28,0x50,0x88,0x88,0xC8,0xA8,0x98,0x88,0x88,0x88,0x00,0x00, // 'Ñ' '\xD1'
    0x40,0x20,0x70,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'Ò' '\xD2'
    0x10,0x20,0x70,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'Ó' '\xD3'
    0x20,0x50,0x70,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'Ô' '\xD4'
    0x28,0x50,0x70,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'Õ' '\xD5'
    0x50,0x50,0x70,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'Ö' '\xD6'
    0x00,0x00,0x00,0x00,0x88,0x50,0x20,0x50,0x88,0x00,0x00,0x00, // '×' '\xD7'
    0x00,0x00,0x74,0x88,0x98,0xA8,0xC8,0x88,0x88,0x70,0x00,0x00, // 'Ø' '\xD8'
    0x40,0x20,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'Ù' '\xD9'
    0x10,0x20,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'Ú' '\xDA'
    0x20,0x50,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'Û' '\xDB'
    0x50,0x50,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'Ü' '\xDC'
    0x10,0x20,0x88,0x88,0x50,0x50,0x20,0x20,0x20,0x20,0x00,0x00, // 'Ý' '\xDD'
    0x00,0x00,0x80,0xF0,0x88,0x88,0x88,0xF0,0x80,0x80,0x00,0x00, // 'Þ' '\xDE'
    0x00,0x00,0xE0,0x90,0x90,0xF0,0x88,0x88,0xC8,0xB0,0x00,0x00, // 'ß' '\xDF'
    0x00,0x00,0x40,0x20,0x70,0x08,0x78,0x88,0x88,0x78,0x00,0x00, // 'à' '\xE0'
    0x00,0x00,0x10,0x20,0x70,0x08,0x78,0x88,0x88,0x78,0x00,0x00, // 'á' '\xE1'
    0x00,0x00,0x20,0x50,0x70,0x08,0x78,0x88,0x88,0x78,0x00,0x00, // 'â' '\xE2'
    0x00,0x00,0x28,0x50,0x70,0x08,0x78,0x88,0x88,0x78,0x00,0x00, // 'ã' '\xE3'
    0x00,0x00,0x50,0x50,0x70,0x08,0x78,0x88,0x88,0x78,0x00,0x00, // 'ä' '\xE4'
    0x00,0x00,0x20,0x50,0x70,0x08,0x78,0x88,0x88,0x78,0x00,0x00, // 'å' '\xE5'
    0x00,0x00,0x00,0x00,0x70,0x28,0x68,0xB0,0xA0,0x78,0x00,0x00, // 'æ' '\xE6'
    0x00,0x00,0x00,0x00,0x70,0x88,0x80,0x80,0x88,0x70,0x20,0x40, // 'ç' '\xE7'
    0x00,0x00,0x40,0x20,0x70,0x88,0xF8,0x80,0x88,0x70,0x00,0x00, // 'è' '\xE8'
    0x00,0x00,0x10,0x20,0x70,0x88,0xF8,0x80,0x88,0x70,0x00,0x00, // 'é' '\xE9'
    0x00,0x00,0x20,0x50,0x70,0x88,0xF8,0x80,0x88,0x70,0x00,0x00, // 'ê' '\xEA'
    0x00,0x00,0x50,0x50,0x70,0x88,0xF8,0x80,0x88,0x70,0x00,0x00, // 'ë' '\xEB'
    0x00,0x00,0x40,0x20,0x60,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // 'ì' '\xEC'
    0x00,0x00,0x10,0x20,0x60,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // 'í' '\xED'
    0x00,0x00,0x20,0x50,0x60,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // 'î' '\xEE'
    0x00,0x00,0x50,0x50,0x60,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // 'ï' '\xEF'
    0x00,0xA0,0x40,0xA0,0x70,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'ð' '\xF0'
    0x00,0x00,0x28,0x50,0xF0,0x88,0x88,0x88,0x88,0x88,0x00,0x00, // 'ñ' '\xF1'
    0x00,0x00,0x40,0x20,0x70,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'ò' '\xF2'
    0x00,0x00,0x10,0x20,0x70,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'ó' '\xF3'
    0x00,0x00,0x20,0x50,0x70,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'ô' '\xF4'
    0x00,0x00,0x28,0x50,0x70,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'õ' '\xF5'
    0x00,0x00,0x50,0x50,0x70,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 'ö' '\xF6'
    0x00,0x00,0x00,0x20,0x20,0x00,0xF8,0x00,0x20,0x20,0x00,0x00, // '÷' '\xF7'
    0x00,0x00,0x00,0x00,0x34,0x48,0x58,0x68,0x48,0xB0,0x00,0x00, // 'ø' '\xF8'
    0x00,0x00,0x40,0x20,0x88,0x88,0x88,0x88,0x88,0x78,0x00,0x00, // 'ù' '\xF9'
    0x00,0x00,0x10,0x20,0x88,0x88,0x88,0x88,0x88,0x78,0x00,0x00, // 'ú' '\xFA'
    0x00,0x00,0x20,0x50,0x88,0x88,0x88,0x88,0x88,0x78,0x00,0x00, // 'û' '\xFB'
    0x00,0x00,0x50,0x50,0x88,0x88,0x88,0x88,0x88,0x78,0x00,0x00, // 'ü' '\xFC'
    0x00,0x00,0x10,0x20,0x88,0x88,0x88,0x88,0x88,0x78,0x08,0x70, // 'ý' '\xFD'
    0x00,0x00,0x80,0x80,0xF0,0x88,0x88,0x88,0x88,0xF0,0x80,0x80, // 'þ' '\xFE'
    0x00,0x00,0x50,0x50,0x88,0x88,0x88,0x88,0x88,0x78,0x08,0x70, // 'ÿ' '\xFF'
};

const int16_t TerminusCharOffsets[] = {
    0,12,24,36, // 35
    48,60,72,84,96, // 40
    108,120,132,144,156, // 45
    168,180,192,204,216, // 50
    228,240,252,264,276, // 55
    288,300,312,324,336, // 60
    348,360,372,384,396, // 65
    408,420,432,444,456, // 70
    468,480,492,504,516, // 75
    528,540,552,564,576, // 80
    588,600,612,624,636, // 85
    648,660,672,684,696, // 90
    708,720,732,744,756, // 95
    768,780,792,804,816, // 100
    828,840,852,864,876, // 105
    888,900,912,924,936, // 110
    948,960,972,984,996, // 115
    1008,1020,1032,1044,1056, // 120
    1068,1080,1092,1104,1116, // 125
    1128, // 126
    -1, // 127
    1140, // 128
    -1, // 129
    -1, -1, -1, -1, -1, -1, -1, -1, -1, // 138
    1152, // 139
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, // 150
    -1, -1, -1, -1, // 154
    1164, // 155
    -1, -1, -1, -1, // 159
    1176, // 160
    1188,1200,1212,1224,1236, // 165
    1248,1260,1272,1284,1296, // 170
    1308,1320,1332,1344,1356, // 175
    1368,1380,1392,1404,1416, // 180
    1428,1440,1452,1464,1476, // 185
    1488,1500,1512,1524,1536, // 190
    1548,1560,1572,1584,1596, // 195
    1608,1620,1632,1644,1656, // 200
    1668,1680,1692,1704,1716, // 205
    1728,1740,1752,1764,1776, // 210
    1788,1800,1812,1824,1836, // 215
    1848,1860,1872,1884,1896, // 220
    1908,1920,1932,1944,1956, // 225
    1968,1980,1992,2004,2016, // 230
    2028,2040,2052,2064,2076, // 235
    2088,2100,2112,2124,2136, // 240
    2148,2160,2172,2184,2196, // 245
    2204,2216,2228,2240,2252, // 250
    2264,2276,2288,2300,2312, // 255
};

const font_t TerminusFont = {
    .Offset = 32,
    .Width = 8,
    .Height = 12,
    .Position = TerminusCharOffsets,
    .Data = TerminusFontBitmaps
};

const char TerminusBigFontBitmaps[] = {
    // 32
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // ' '
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '!'
    0x00,0x00,0x00,0x00,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '"'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x7F,0xF0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x7F,0xF0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '#'
    0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x1F,0xE0,0x33,0x30,0x63,0x18,0x63,0x00,0x63,0x00,0x63,0x00,0x63,0x00,0x33,0x00,0x1F,0xE0,0x03,0x30,0x03,0x18,0x03,0x18,0x03,0x18,0x03,0x18,0x63,0x18,0x33,0x30,0x1F,0xE0,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '$'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x30,0x66,0x30,0x66,0x60,0x66,0x60,0x3C,0xC0,0x00,0xC0,0x01,0x80,0x01,0x80,0x03,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0xF0,0x19,0x98,0x19,0x98,0x31,0x98,0x30,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '%'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x19,0x80,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x19,0x80,0x0F,0x00,0x0E,0x00,0x1B,0x18,0x31,0x98,0x60,0xF0,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0xF0,0x31,0x98,0x1F,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '&'
    0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '''
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x03,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x06,0x00,0x06,0x00,0x03,0x00,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '('
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x03,0x00,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x03,0x00,0x03,0x00,0x06,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // ')'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x18,0x60,0x0C,0xC0,0x07,0x80,0x03,0x00,0x7F,0xF8,0x03,0x00,0x07,0x80,0x0C,0xC0,0x18,0x60,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '*'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x7F,0xF8,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '+'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x06,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // ','
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '-'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '.'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x60,0x00,0x60,0x00,0xC0,0x00,0xC0,0x01,0x80,0x01,0x80,0x03,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '/'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x70,0x60,0xF0,0x61,0xB0,0x63,0x30,0x66,0x30,0x6C,0x30,0x78,0x30,0x70,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '0'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x07,0x00,0x0F,0x00,0x1B,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x1F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '1'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x30,0x00,0x60,0x00,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0x60,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '2'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x60,0x0F,0xC0,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '3'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x70,0x00,0xF0,0x01,0xB0,0x03,0x30,0x06,0x30,0x0C,0x30,0x18,0x30,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '4'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xC0,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '5'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xE0,0x30,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '6'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF0,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x60,0x00,0x60,0x00,0xC0,0x00,0xC0,0x01,0x80,0x01,0x80,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '7'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '8'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x60,0x3F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '9'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // ':'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x06,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // ';'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x60,0x00,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x01,0x80,0x00,0xC0,0x00,0x60,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '<'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '='
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x01,0x80,0x00,0xC0,0x00,0x60,0x00,0x30,0x00,0x60,0x00,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x60,0x00,0xC0,0x01,0x80,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '?'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xE0,0x30,0x30,0x60,0x18,0x60,0x18,0x61,0xF8,0x63,0x18,0x66,0x18,0x66,0x18,0x66,0x18,0x66,0x18,0x66,0x18,0x66,0x18,0x63,0x18,0x61,0xE8,0x60,0x00,0x60,0x00,0x30,0x00,0x1F,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '@'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'A'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x60,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x60,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'B'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'C'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x61,0xC0,0x60,0x60,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x60,0x60,0x60,0x61,0xC0,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'D'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'E'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'F'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x63,0xF0,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'G'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'H'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xC0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'I'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xF8,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x30,0xC0,0x1F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'J'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x60,0x60,0x60,0xC0,0x61,0x80,0x63,0x00,0x66,0x00,0x6C,0x00,0x78,0x00,0x70,0x00,0x70,0x00,0x78,0x00,0x6C,0x00,0x66,0x00,0x63,0x00,0x61,0x80,0x60,0xC0,0x60,0x60,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'K'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'L'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x18,0x60,0x18,0x70,0x38,0x78,0x78,0x6C,0xD8,0x6C,0xD8,0x67,0x98,0x63,0x18,0x63,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'M'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x70,0x30,0x78,0x30,0x6C,0x30,0x66,0x30,0x63,0x30,0x61,0xB0,0x60,0xF0,0x60,0x70,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'N'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'O'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x60,0x7F,0xC0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'P'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x63,0x30,0x31,0xE0,0x1F,0xC0,0x00,0x60,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Q'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x60,0x7F,0xC0,0x78,0x00,0x6C,0x00,0x66,0x00,0x63,0x00,0x61,0x80,0x60,0xC0,0x60,0x60,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'R'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x00,0x60,0x00,0x60,0x00,0x30,0x00,0x1F,0xC0,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'S'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF8,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'T'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'U'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x0D,0x80,0x0D,0x80,0x0D,0x80,0x07,0x00,0x07,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'V'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x63,0x18,0x63,0x18,0x67,0x98,0x6C,0xD8,0x6C,0xD8,0x78,0x78,0x70,0x38,0x60,0x18,0x60,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'W'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x30,0x60,0x30,0x60,0x18,0xC0,0x18,0xC0,0x0D,0x80,0x0D,0x80,0x07,0x00,0x07,0x00,0x0D,0x80,0x0D,0x80,0x18,0xC0,0x18,0xC0,0x30,0x60,0x30,0x60,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'X'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x18,0x60,0x18,0x30,0x30,0x30,0x30,0x18,0x60,0x18,0x60,0x0C,0xC0,0x0C,0xC0,0x07,0x80,0x07,0x80,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Y'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x60,0x00,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Z'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xC0,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '['
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0x18,0x00,0x0C,0x00,0x0C,0x00,0x06,0x00,0x06,0x00,0x03,0x00,0x03,0x00,0x01,0x80,0x01,0x80,0x00,0xC0,0x00,0xC0,0x00,0x60,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '\'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // ']'
    0x00,0x00,0x00,0x00,0x02,0x00,0x07,0x00,0x0D,0x80,0x18,0xC0,0x30,0x60,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '^'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00, // '_'
    0x0C,0x00,0x06,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '`'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x00,0x60,0x00,0x30,0x00,0x30,0x1F,0xF0,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'a'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x60,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'b'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'c'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x1F,0xF0,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'd'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x30,0x30,0x1F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'e'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xF0,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x3F,0xC0,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'f'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF0,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x60,0x3F,0xC0,0x00,0x00, // 'g'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'h'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'i'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x01,0xE0,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x18,0xC0,0x0F,0x80,0x00,0x00, // 'j'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x30,0x30,0x60,0x30,0xC0,0x31,0x80,0x33,0x00,0x36,0x00,0x3C,0x00,0x36,0x00,0x33,0x00,0x31,0x80,0x30,0xC0,0x30,0x60,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'k'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'l'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xE0,0x63,0x30,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'm'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'n'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'o'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x60,0x7F,0xC0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00, // 'p'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF0,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00, // 'q'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x67,0xF0,0x6C,0x00,0x78,0x00,0x70,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'r'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x00,0x60,0x00,0x30,0x00,0x1F,0xC0,0x00,0x60,0x00,0x30,0x00,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 's'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x3F,0xC0,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x03,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 't'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'u'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x0D,0x80,0x0D,0x80,0x07,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'v'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x33,0x30,0x1F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'w'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x18,0xC0,0x0D,0x80,0x07,0x00,0x0D,0x80,0x18,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'x'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x60,0x3F,0xC0,0x00,0x00, // 'y'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,0x30,0x00,0x60,0x00,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0x60,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'z'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0x03,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x1C,0x00,0x1C,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x03,0x00,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '{'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '|'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x06,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x01,0xC0,0x01,0xC0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x06,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '}'
    // 126
    0x00,0x00,0x00,0x00,0x3C,0x30,0x66,0x30,0x63,0x30,0x63,0x30,0x61,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '~'
    // 128
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xE0,0x03,0x18,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0x60,0x00,0xFF,0xF0,0x60,0x00,0x60,0x00,0xFF,0x80,0x18,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x01,0x84,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '€'
    // 139
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '‹'
    // 155
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x03,0x00,0x01,0x80,0x00,0xC0,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '›'
    // 160
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // ' '
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¡'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x1B,0x60,0x33,0x30,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x30,0x1B,0x60,0x0F,0xC0,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¢'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x80,0x0C,0xC0,0x18,0x60,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x3F,0x80,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x30,0x38,0x30,0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '£'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x18,0x30,0x30,0x1F,0xE0,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x1F,0xE0,0x30,0x30,0x60,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¤'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x18,0x60,0x18,0x30,0x30,0x30,0x30,0x18,0x60,0x18,0x60,0x0C,0xC0,0x0C,0xC0,0x07,0x80,0x03,0x00,0x03,0x00,0x3F,0xF0,0x03,0x00,0x03,0x00,0x3F,0xF0,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¥'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¦'
    0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x80,0x0C,0xC0,0x18,0x60,0x18,0x00,0x1C,0x00,0x0F,0x00,0x0D,0x80,0x18,0xC0,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x0C,0x60,0x06,0xC0,0x03,0xC0,0x00,0xE0,0x00,0x60,0x18,0x60,0x0C,0xC0,0x07,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '§'
    0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¨'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xE0,0x60,0x30,0xCF,0x98,0xD8,0xD8,0xD8,0xD8,0xD8,0x18,0xD8,0x18,0xD8,0x18,0xD8,0x18,0xD8,0xD8,0xD8,0xD8,0xCF,0x98,0x60,0x30,0x3F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '©'
    0x00,0x00,0x1F,0xC0,0x00,0x60,0x00,0x30,0x0F,0xF0,0x18,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x18,0x30,0x0F,0xF0,0x00,0x00,0x00,0x00,0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ª'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x98,0x03,0x30,0x06,0x60,0x0C,0xC0,0x19,0x80,0x33,0x00,0x66,0x00,0x33,0x00,0x19,0x80,0x0C,0xC0,0x06,0x60,0x03,0x30,0x01,0x98,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '«'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¬'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '­'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xE0,0x60,0x30,0xDF,0x98,0xD8,0xD8,0xD8,0xD8,0xD8,0xD8,0xD8,0xD8,0xDF,0x98,0xDE,0x18,0xDB,0x18,0xD9,0x98,0xD8,0xD8,0x60,0x30,0x3F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '®'
    0x00,0x00,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¯'
    0x00,0x00,0x00,0x00,0x0F,0x80,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x0F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '°'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x7F,0xF8,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '±'
    0x00,0x00,0x00,0x00,0x0F,0x80,0x18,0xC0,0x18,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '²'
    0x00,0x00,0x00,0x00,0x0F,0x80,0x18,0xC0,0x00,0xC0,0x07,0x80,0x00,0xC0,0x00,0xC0,0x18,0xC0,0x0F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '³'
    0x01,0x80,0x03,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '´'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x70,0x60,0xF0,0x61,0xB0,0x7F,0x30,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00, // 'µ'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xF8,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x63,0x18,0x3F,0x18,0x03,0x18,0x03,0x18,0x03,0x18,0x03,0x18,0x03,0x18,0x03,0x18,0x03,0x18,0x03,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¶'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '·'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x00,0x00, // '¸'
    0x00,0x00,0x00,0x00,0x03,0x00,0x07,0x00,0x0F,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¹'
    0x00,0x00,0x0F,0xC0,0x18,0x60,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x18,0x60,0x0F,0xC0,0x00,0x00,0x00,0x00,0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'º'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x66,0x00,0x33,0x00,0x19,0x80,0x0C,0xC0,0x06,0x60,0x03,0x30,0x01,0x98,0x03,0x30,0x06,0x60,0x0C,0xC0,0x19,0x80,0x33,0x00,0x66,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '»'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1C,0x00,0x3C,0x00,0x0C,0x00,0x0C,0x10,0x0C,0x30,0x0C,0x60,0x0C,0xC0,0x01,0x80,0x03,0x30,0x06,0x70,0x0C,0xF0,0x19,0xB0,0x33,0x30,0x66,0x30,0x47,0xF0,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¼'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x38,0x00,0x78,0x10,0x18,0x30,0x18,0x60,0x18,0xC0,0x19,0x80,0x1B,0x00,0x06,0x00,0x0C,0x00,0x1B,0xE0,0x36,0x30,0x66,0x30,0x40,0x60,0x00,0xC0,0x01,0x80,0x03,0x00,0x07,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '½'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x63,0x00,0x03,0x00,0x1E,0x00,0x03,0x08,0x03,0x18,0x63,0x30,0x3E,0x60,0x00,0xC0,0x01,0x98,0x03,0x38,0x06,0x78,0x0C,0xD8,0x19,0x98,0x33,0x18,0x63,0xF8,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¾'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '¿'
    0x0C,0x00,0x06,0x00,0x03,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'À'
    0x01,0x80,0x03,0x00,0x06,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Á'
    0x07,0x00,0x0D,0x80,0x18,0xC0,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Â'
    0x1C,0x60,0x37,0x60,0x31,0xC0,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ã'
    0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ä'
    0x07,0x80,0x0C,0xC0,0x0C,0xC0,0x07,0x80,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Å'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xF8,0x63,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xFF,0xF0,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Æ'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x00,0x00, // 'Ç'
    0x0C,0x00,0x06,0x00,0x03,0x00,0x00,0x00,0x7F,0xF0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'È'
    0x01,0x80,0x03,0x00,0x06,0x00,0x00,0x00,0x7F,0xF0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'É'
    0x07,0x00,0x0D,0x80,0x18,0xC0,0x00,0x00,0x7F,0xF0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ê'
    0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x7F,0xF0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ë'
    0x0C,0x00,0x06,0x00,0x03,0x00,0x00,0x00,0x0F,0xC0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ì'
    0x00,0xC0,0x01,0x80,0x03,0x00,0x00,0x00,0x0F,0xC0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Í'
    0x07,0x00,0x0D,0x80,0x18,0xC0,0x00,0x00,0x0F,0xC0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Î'
    0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x0F,0xC0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ï'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x61,0xC0,0x60,0x60,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0xFE,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x60,0x60,0x60,0x61,0xC0,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ð'
    0x1C,0x60,0x37,0x60,0x31,0xC0,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x70,0x30,0x78,0x30,0x6C,0x30,0x66,0x30,0x63,0x30,0x61,0xB0,0x60,0xF0,0x60,0x70,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ñ'
    0x0C,0x00,0x06,0x00,0x03,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ò'
    0x01,0x80,0x03,0x00,0x06,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ó'
    0x07,0x00,0x0D,0x80,0x18,0xC0,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ô'
    0x1C,0x60,0x37,0x60,0x31,0xC0,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Õ'
    0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ö'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x18,0x30,0x30,0x18,0x60,0x0C,0xC0,0x07,0x80,0x03,0x00,0x07,0x80,0x0C,0xC0,0x18,0x60,0x30,0x30,0x60,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '×'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x38,0x60,0x30,0x60,0x70,0x60,0xF0,0x61,0xB0,0x63,0x30,0x66,0x30,0x6C,0x30,0x78,0x30,0x70,0x30,0x60,0x30,0xE0,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ø'
    0x0C,0x00,0x06,0x00,0x03,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ù'
    0x01,0x80,0x03,0x00,0x06,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ú'
    0x07,0x00,0x0D,0x80,0x18,0xC0,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Û'
    0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ü'
    0x00,0xC0,0x01,0x80,0x03,0x00,0x00,0x00,0x60,0x18,0x60,0x18,0x30,0x30,0x30,0x30,0x18,0x60,0x18,0x60,0x0C,0xC0,0x0C,0xC0,0x07,0x80,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Ý'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x60,0x7F,0xC0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'Þ'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x80,0x60,0xC0,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0xC0,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x70,0x30,0x6C,0x60,0x67,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ß'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x00,0x00,0x1F,0xC0,0x00,0x60,0x00,0x30,0x00,0x30,0x1F,0xF0,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'à'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x03,0x00,0x06,0x00,0x00,0x00,0x1F,0xC0,0x00,0x60,0x00,0x30,0x00,0x30,0x1F,0xF0,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'á'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x0D,0x80,0x18,0xC0,0x00,0x00,0x1F,0xC0,0x00,0x60,0x00,0x30,0x00,0x30,0x1F,0xF0,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'â'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x60,0x37,0x60,0x31,0xC0,0x00,0x00,0x1F,0xC0,0x00,0x60,0x00,0x30,0x00,0x30,0x1F,0xF0,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ã'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x1F,0xC0,0x00,0x60,0x00,0x30,0x00,0x30,0x1F,0xF0,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ä'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x80,0x0C,0xC0,0x0C,0xC0,0x07,0x80,0x1F,0xC0,0x00,0x60,0x00,0x30,0x00,0x30,0x1F,0xF0,0x30,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'å'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7D,0xE0,0x07,0x30,0x03,0x18,0x03,0x18,0x03,0x18,0x3F,0x18,0x63,0xF8,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0x63,0x98,0x3E,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'æ'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x30,0x30,0x60,0x1F,0xC0,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x00,0x00, // 'ç'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x30,0x30,0x1F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'è'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x03,0x00,0x06,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x30,0x30,0x1F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'é'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x0D,0x80,0x18,0xC0,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x30,0x30,0x1F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ê'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x7F,0xF0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x30,0x30,0x1F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ë'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x00,0x00,0x0F,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ì'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x01,0x80,0x03,0x00,0x00,0x00,0x0F,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'í'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x0D,0x80,0x18,0xC0,0x00,0x00,0x0F,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'î'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x0F,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ï'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x80,0x0F,0x00,0x1E,0x00,0x33,0x00,0x01,0x80,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ð'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x60,0x66,0x60,0x63,0xC0,0x00,0x00,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ñ'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ò'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x03,0x00,0x06,0x00,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ó'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x0D,0x80,0x18,0xC0,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ô'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x60,0x37,0x60,0x31,0xC0,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'õ'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x1F,0xC0,0x30,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x60,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ö'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '÷'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xD8,0x30,0x78,0x60,0x70,0x60,0xF0,0x61,0xB0,0x63,0x30,0x66,0x30,0x6C,0x30,0x78,0x30,0x70,0x30,0x60,0x30,0xF0,0x60,0xDF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ø'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ù'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x03,0x00,0x06,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ú'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x0D,0x80,0x18,0xC0,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'û'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 'ü'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x03,0x00,0x06,0x00,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x60,0x3F,0xC0,0x00,0x00, // 'ý'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0xC0,0x60,0x60,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x60,0x7F,0xC0,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00, // 'þ'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x00,0x00,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x30,0x30,0x1F,0xF0,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x60,0x3F,0xC0,0x00,0x00, // 'ÿ'
};

const int16_t TerminusBigCharOffsets[] = {
    // 32
    0,56,112,168, // 35
    224,280,336,392,448, // 40
    504,560,616,672,728, // 50
    784,840,896,952,1008, // 55
    1064,1120,1176,1232,1288, // 60
    1344,1400,1456,1512,1568, // 65
    1624,1680,1736,1792,1848, // 70
    1904,1960,2016,2072,2128, // 75
    2184,2240,2296,2352,2408, // 80
    2464,2520,2576,2632,2688, // 85
    2744,2800,2856,2912,2968, // 90
    3024,3080,3136,3192,3248, // 95
    3304,3360,3416,3472,3528, // 100
    3584,3640,3696,3752,3808, // 105
    3864,3920,3976,4032,4088, // 110
    4144,4200,4256,4312,4368, // 115
    4424,4480,4536,4592,4648, // 120
    4704,4760,4816,4872,4928, // 125
    4984, // 126
    -1, // 127
    5040, // 128
    -1,-1, // 130
    -1, -1, -1, -1, -1, -1, -1, -1, // 138
    5096, // 139
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, // 150
    -1, -1, -1, -1, // 154
    5152, // 155
    -1, -1, -1, -1, // 159
    5208, // 160
    5264,5320,5376,5432,5488, // 165
    5544,5600,5656,5712,5768, // 170
    5824,5880,5936,5992,6048, // 175
    6104,6160,6216,6272,6328, // 180
    6384,6440,6496,6552,6608, // 185
    6664,6720,6776,6832,6888, // 190
    6944,7000,7056,7112,7168, // 195
    7224,7280,7336,7392,7448, // 200
    7504,7560,7616,7672,7728, // 205
    7784,7840,7896,7952,8008, // 210
    8064,8120,8176,8232,8288, // 215
    8344,8400,8456,8512,8568, // 220
    8624,8680,8736,8792,8848, // 225
    8904,8960,9016,9072,9128, // 230
    9184,9240,9296,9352,9408, // 235
    9464,9520,9576,9632,9688, // 240
    9744,9800,9856,9912,9968, // 245
    10024,10080,10136,10192,10248, // 250
    10304,10360,10416,10472,10528, // 255
};

const font_t TerminusBigFont = {
    .Offset = 32,
    .Width = 16,
    .Height = 28,
    .Position = TerminusBigCharOffsets,
    .Data = TerminusBigFontBitmaps
};
