#include "mbed.h"
#include "stdio.h"
#include "MbedJSONValue.h"
#include "QEI.h"
#include "string.h"
#include "stdint.h"
#include <cstdlib>
#define NUM_FIELDS  3 
#define MAX_BUFFER 500



Thread thread;
//Ticker timer;

Serial pc(USBTX,USBRX);
AnalogOut DataDAC(p18);
Serial gps(p13, p14);
QEI wheel (p29, p30, NC, 250, QEI::X4_ENCODING);


char eDataBuffer[500];
int i = 0;
int h_time,m_time,s_time;
char testStringBuffer[MAX_BUFFER]={0};
bool stringComplete = false;
double DAC_Value;
int len = 0;
//number of comma seperated values in the data...TODO does this remain constant?
float latitude, longitude, timefix, speed, altitude;
char ns, ew;
void Init();
void parseGPS(char *cmd, int n);
void parseTime (float timeval);
void baca_gps();
void input_DAC();




void clearBuffer(char* buffer , int len){
    for (int i =0; i<len ; i++){
        buffer[i] = '\0';  
    }
}
  
void onSerialInput() {
  if(pc.readable()){ 
    char inChar = pc.getc();
    //pc.printf("%c",inChar);
    testStringBuffer[len] = inChar;    
    len++;       
    if (inChar == '\n') {
             //   pc.printf("%s",testStringBuffer);
                stringComplete = true;
                len = 0;
     }
    }
}

void Init()
{
     gps.baud(9600);
     pc.baud(115200);
     pc.attach(&onSerialInput);
     gps.attach(&baca_gps);
     pc.printf("Init OK\n");
}

float baca_enc() 
{ 
    float lp;
    int pul =wheel.getPulses();
    lp = (pul / 4*250)*0.04 ;
    return lp;
}

void reset_enc() 
{ 
    wheel.reset();
}

void parseTime (float timeval)
{
    //format utc time to beijing time,add 8 time zone
                float time = timeval + 80000.00f;
                h_time = int(time) / 10000;
                m_time = (int(time) % 10000) / 100;
                s_time = int(time) % 100;
}


/* 
 * NMEA sentences:  https://www.gpsinformation.org/dale/nmea.htm#nmea
 *                  http://navspark.mybigcommerce.com/content/NMEA_Format_v0.1.pdf
 */
void parseGPS(char *cmd, int n)
{   
    char tf, status;
    int fq, nst, fix, date;                                     // fix quality, Number of satellites being tracked, 3D fix
   
    
    // Global Positioning System Fix Data
    if(strncmp(cmd,"$GPGGA", 6) == 0) 
    {
        sscanf(cmd, "$GPGGA,%f,%f,%c,%f,%c,%d,%d,%*f,%f", &timefix, &latitude, &ns, &longitude, &ew, &fq, &nst, &altitude);
        //pc.printf("Latitude: %f %c, Longitude: %f %c \n", latitude, ns, longitude, ew);
        
        
    }
    
    // Satellite status
     else if(strncmp(cmd,"$GPGSA", 6) == 0) 
    {
        sscanf(cmd, "$GPGSA,%c,%d,%d", &tf, &fix, &nst);
        //pc.printf("GPGSA Type fix: %c, 3D fix: %d, number of sat: %d\r\n", tf, fix, nst);
    }
    
    // Geographic position, Latitude and Longitude
    else if(strncmp(cmd,"$GPGLL", 6) == 0) 
    {
        sscanf(cmd, "$GPGLL,%f,%c,%f,%c,%f", &latitude, &ns, &longitude, &ew, &timefix);
        //pc.printf("GPGLL Latitude: %f %c, Longitude: %f %c\n", latitude, ns, longitude, ew);
    }
    
    // Geographic position, Latitude and Longitude
    else if(strncmp(cmd,"$GPRMC", 6) == 0) 
    {
        sscanf(cmd, "$GPRMC,%f,%c,%f,%c,%f,%c,%f,,%d", &timefix, &status, &latitude, &ns, &longitude, &ew, &speed, &date);
        //pc.printf("GPRMC Latitude: %f %c, Longitude: %f %c\n", latitude, ns, longitude, ew);
    }
    
    // 
    else if(strncmp(cmd,"$GNVTG", 6) == 0) 
    {
     //   pc.printf("its a Vector Track message.\n");
    }
    
    else if(strncmp(cmd,"$GNGGA", 6) == 0) 
    {
        sscanf(cmd, "$GNGGA,%f,%f,%c,%f,%c,%d,%d,%*f,%f", &timefix, &latitude, &ns, &longitude, &ew, &fq, &nst, &altitude);
       //pc.printf("GNGGA Latitude: %f %c, Longitude: %f %c \n", latitude, ns, longitude, ew);
        parseTime(timefix);
       // pc.printf("Time: %d:%d:%d\n", h_time, m_time, s_time);
    }
    
    else if(strncmp(cmd,"$GNGSA", 6) == 0) 
    {
        sscanf(cmd, "$GNGSA,%c,%d,%d", &tf, &fix, &nst);
        //pc.printf("GNGSA Type fix: %c, 3D fix: %d, number of sat: %d\r\n", tf, fix, nst);
    }
    
    else if(strncmp(cmd,"$GPGSV", 6) == 0) 
    {
     //   pc.printf("its a Satellite details message.\n");
    }
    
    else if(strncmp(cmd,"$GNGLL", 6) == 0) 
    {
        sscanf(cmd, "$GNGLL,%f,%c,%f,%c,%f", &latitude, &ns, &longitude, &ew, &timefix);
        //pc.printf("GNGLL Latitude: %f %c, Longitude: %f %c \n", latitude, ns, longitude, ew);
    }
    
    else
    {
   //     pc.printf("Unknown message type\n");
    }
}
/*void input_DAC(){
    DataDAC = DAC_Value;
}*/

char e;
void baca_gps() 
{   
      while(gps.readable())
        { 
            
            if(gps.getc() == '$');           // wait a $
            {
                for(int i=0; i<sizeof(eDataBuffer); i++)
                {
                    e = gps.getc();
                    if( e == '\r' )
                    {
                        pc.printf("%s\n", eDataBuffer);
                        parseGPS(eDataBuffer, i);
                        i = sizeof(eDataBuffer);
                    }
                    else
                    {
                        eDataBuffer[i] = e;
                        
                    }                 
                }
            }
         } 
    
}
#define TOTAL_DATA 20
bool threadFlag = false;
MbedJSONValue threadDAC;
void DAC_Thread(){
    int periode;    
    int counterDAC = 0;    
    while (true) {         
        if (threadFlag){
           
            periode = threadDAC["periode"].get<int>();
            float m = periode/20;
                                           
                DAC_Value = threadDAC["value"][counterDAC].get<double>();
                
                //for (int k=0;k<20;k++){ 
                DataDAC = DAC_Value;              
                wait_us(m*100);
                
                //}
                
                counterDAC++;   
                if(counterDAC>=TOTAL_DATA){
                   counterDAC = 0;   
                 //continue;
                } 
                
            }
            
            
       
        else {            
            DataDAC = 0;
            counterDAC = 0;        
                  
        }
        
    }
}

int main()
{
    //float e[5]={0};
    Init();  
    MbedJSONValue json;
    MbedJSONValue jsonGPS;
    MbedJSONValue jsonENCO;
    thread.start(DAC_Thread);
    std::string buffer;
    
    while(1){
       if (stringComplete){
            parse(json,testStringBuffer);
            if (json.hasMember("type")){
                if(json["type"].get<std::string>() == "STOP"){
                    
                    threadFlag = false; 
                    DataDAC = 0;
                    wait(1);
                    NVIC_SystemReset();
                    
                      
                }
                else if (json["type"].get<std::string>() == "DAC"){
                    
                    threadDAC = json;   
                    threadFlag = true;   
                    
                }
                else if(json["type"].get<std::string>() == "ENCO"){
                    jsonENCO["type"] = "ENCO";
                    jsonENCO["Pos"] = baca_enc();
                    buffer = jsonENCO.serialize();
                    pc.printf("%s\n",buffer.c_str());
                    //wait(0.5);
                }
                else if(json["type"].get<std::string>() == "ENCO_RESET"){
                    reset_enc();
                }
                else if(json["type"].get<std::string>() == "GPS"){              
                    jsonGPS["type"] = "GPS";
                    jsonGPS["lat"] = latitude;
                    jsonGPS["ns"] = ns;
                    jsonGPS["long"] = longitude;
                    jsonGPS["ew"]  = ew;
                    buffer = jsonGPS.serialize();
                    pc.printf("%s\n",buffer.c_str());
                   
                    
                }
               
                else {
                     pc.printf("Type is not available\n");
                }
                stringComplete = false;
                clearBuffer(testStringBuffer,MAX_BUFFER);
            }
            else{
                pc.printf("Unknown JSON Message \n");
                stringComplete = false;
                clearBuffer(testStringBuffer,MAX_BUFFER);
            }

            
        }
        
    }
}