/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include <vector>  
#include <iostream>

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500
using namespace std;

void findPeaks(float *num,int count, float threshold)  
{  
    vector<int> sign;  
    for(int i = 1;i<count;i++)  
    {  
        /*do difference between the near points： 
         *result<0，sign = -1 
         *result>0，sign = 1 
         *result=0，sign = 0 
         */  
        int diff = num[i] - num[i-1];  
        if(diff>0)  
        {  
            sign.push_back(1);  
        }  
        else if(diff<0)  
        {  
            sign.push_back(-1);  
        }  
        else  
        {  
            sign.push_back(0);  
        }  
    }  
    //do difference between the near sign
    //result < 0 save the max index
    //result > 0 save the min index 
    vector<int> indMax;  
    vector<int> indMin;  
    int cnt = 1;
    for(int j = 1;j<sign.size();j++)  
    {  
        int diff = sign[j]-sign[j-1];  
        if(diff<0)  
        {  
            indMax.push_back(j);  
        }  
        else if(diff>0)  
        {  
            indMin.push_back(j);  
        }  
    }  
    //try to find the valid max (which the previous min is smaller than threshold)
    //begin with index 1 so there will have +1 or -1 error
    for(int j = 1;j<indMax.size();j++)  
    {
        
        for(int i =0; i <indMin.size()-1; i++)
        {
            if(indMin[i]<indMax[j] && indMin[i+1]>indMax[j] && num[indMin[i]]< threshold)
            {
                cnt = cnt +1;    
                printf("found a valid max, index:%d, value: %f \n\r", indMax[j],num[indMax[j]]);
            }    
        }
        
    }
    printf("num of max: %d\n\r", indMax.size());
    printf("num of valid max: %d\n\r", cnt);
    
    cout<<"max values:"<<endl;
    for(int m = 0;m<indMax.size();m++)  
    {  
        cout<<num[indMax[m]]<<"  ";  
    }  
    cout<<endl;  
    cout<<"min values："<<endl;  
    for(int n = 0;n<indMin.size();n++)  
    {  
        cout<<num[indMin[n]]<<"  ";  
    }  
    cout<<endl;
}  

int main()
{
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    float a[] = {1,2,10,2,4,0,8,10,23,0,2, 0, 5};  
    int len = sizeof(a)/sizeof(int);
    while (true) {
        //printf("len of a is %d \n\r", len);
        findPeaks(a,len,1); 
        led = !led;
        thread_sleep_for(BLINKING_RATE_MS);
    }
}
