# include "AD7390.h"
#include "mbed.h"

AD7390::AD7390(SPI& _spi, PinName resetpin, PinName latchpin) : //Mosi, sclk 2x digital out refV
    spi(_spi),reset(resetpin), latch(latchpin){
    }
    void AD7390::Init(int Frequency)
    {
        //Vout = (Vref*D)/2^n
        spi.frequency(Frequency);
        spi.format(12,0);
        latch = 1;                                              
        reset = 0;
        reset = 1;
    }
    
    void AD7390::Reset()                                        
    {
        reset = 0;
        reset = 1;                                              
    }
    void AD7390::Latch()                                        
    {
        latch = 0;
        latch = 1;
    }
    void AD7390::Write(float Volts, float RefV)                 //write will require seperate latch after
    {
        unsigned int send = 0x0000;
        send = (unsigned int) (4096/RefV)*Volts;
        spi.write(send);
    }
    void AD7390::WriteL(float volts, float RefV)                //Same as write but with latch attached
    {
        unsigned int Send = 0x0000;
        Send = (unsigned int) (4096/RefV)*volts;                //parse float into unsigned int to send to DAC
        spi.write(Send);
        latch = 0;
        latch = 1;
    }
        
        
    
    