/*
    OSCtoCV Shift Sequencer & M185 Sequencer
*/

#pragma O3
#pragma Otime

#ifndef OSCtoCV_LFO_h
#define OSCtoCV_LFO_h

#include "mbed.h"

#define TRIANGLE_WAVE        0
#define SQUARE_WAVE          1
#define SAW_WAVE             2
#define SINE_WAVE            3
#define EXP_WAVE             4
#define LOG_WAVE             5
#define SYNTH_WAVE           6
#define NOISE                7

#define WAVEFORM_TOTAL       8

// LFO Quantize Map
const float quantizedMap[1024] = {
0.000000,  31.500000, 63.000000,  94.500000, 126.000000,  157.500000, 189.000000,  220.500000, 252.000000,
283.500000,   315.000000,  346.500000,   378.000000,  409.500000,   441.000000,  472.500000,   504.000000,
535.500000,   567.000000,  598.500000,   630.000000,  661.500000,   693.000000,  724.500000,   756.000000,
787.500000,  819.000000,   850.500000,  882.000000,   913.500000,  945.000000,   976.500000,  1008.000000,
1039.500000, 1071.000000,  1102.500000, 1134.000000,  1165.500000, 1197.000000,  1228.500000, 1260.000000,
1291.500000, 1323.000000,  1354.500000, 1386.000000,  1417.500000, 1449.000000,  1480.500000, 1512.000000,
1543.500000, 1575.000000,  1606.500000, 1638.000000,  1669.500000, 1701.000000,  1732.500000, 1764.000000,
1795.500000, 1827.000000,  1858.500000, 1890.000000,  1921.500000, 1953.000000,  1984.500000, 2016.000000,
2047.500000, 2079.000000,  2110.500000, 2142.000000,  2173.500000, 2205.000000,  2236.500000, 2268.000000,
2299.500000, 2331.000000,  2362.500000, 2394.000000,  2425.500000, 2457.000000,  2488.500000, 2520.000000,
2551.500000, 2583.000000,  2614.500000, 2646.000000,  2677.500000, 2709.000000,  2740.500000, 2772.000000,
2803.500000, 2835.000000,  2866.500000, 2898.000000,  2929.500000, 2961.000000,  2992.500000, 3024.000000,
3055.500000, 3087.000000,  3118.500000, 3150.000000,  3181.500000, 3213.000000,  3244.500000, 3276.000000,
3307.500000, 3339.000000,  3370.500000, 3402.000000,  3433.500000, 3465.000000,  3496.500000, 3528.000000,
3559.500000, 3591.000000,  3622.500000, 3654.000000,  3685.500000, 3717.000000,  3748.500000, 3780.000000,
3811.500000, 3843.000000,  3874.500000, 3906.000000,  3937.500000, 3969.000000,  4000.500000, 4032.000000,
4063.500000, 4095.000000,  4126.500000, 4158.000000,  4189.500000, 4221.000000,  4252.500000, 4284.000000,
4315.500000, 4347.000000,  4378.500000, 4410.000000,  4441.500000, 4473.000000,  4504.500000, 4536.000000,
4567.500000, 4599.000000,  4630.500000, 4662.000000,  4693.500000, 4725.000000,  4756.500000, 4788.000000,
4819.500000, 4851.000000,  4882.500000, 4914.000000,  4945.500000, 4977.000000,  5008.500000, 5040.000000,
5071.500000, 5103.000000,  5134.500000, 5166.000000,  5197.500000, 5229.000000,  5260.500000, 5292.000000,
5323.500000, 5355.000000,  5386.500000, 5418.000000,  5449.500000, 5481.000000,  5512.500000, 5544.000000,
5575.500000, 5607.000000,  5638.500000, 5670.000000,  5701.500000, 5733.000000,  5764.500000, 5796.000000,
5827.500000, 5859.000000,  5890.500000, 5922.000000,  5953.500000, 5985.000000,  6016.500000, 6048.000000,
6079.500000, 6111.000000,  6142.500000, 6174.000000,  6205.500000, 6237.000000,  6268.500000, 6300.000000,
6331.500000, 6363.000000,  6394.500000, 6426.000000,  6457.500000, 6489.000000,  6520.500000, 6552.000000,
6583.500000, 6615.000000,  6646.500000, 6678.000000,  6709.500000, 6741.000000,  6772.500000, 6804.000000,
6835.500000, 6867.000000,  6898.500000, 6930.000000,  6961.500000, 6993.000000,  7024.500000, 7056.000000,
7087.500000, 7119.000000,  7150.500000, 7182.000000,  7213.500000, 7245.000000,  7276.500000, 7308.000000,
7339.500000, 7371.000000,  7402.500000, 7434.000000,  7465.500000, 7497.000000,  7528.500000, 7560.000000,
7591.500000, 7623.000000,  7654.500000, 7686.000000,  7717.500000, 7749.000000,  7780.500000, 7812.000000,
7843.500000, 7875.000000,  7906.500000, 7938.000000,  7969.500000, 8001.000000,  8032.500000, 8064.000000,
8095.500000, 8127.000000,  8158.500000, 8190.000000,  8221.500000, 8253.000000,  8284.500000, 8316.000000,
8347.500000, 8379.000000,  8410.500000, 8442.000000,  8473.500000, 8505.000000,  8536.500000, 8568.000000,
8599.500000, 8631.000000,  8662.500000, 8694.000000,  8725.500000, 8757.000000,  8788.500000, 8820.000000,
8851.500000, 8883.000000,  8914.500000, 8946.000000,  8977.500000, 9009.000000,  9040.500000, 9072.000000,
9103.500000, 9135.000000,  9166.500000, 9198.000000,  9229.500000, 9261.000000,  9292.500000, 9324.000000,
9355.500000, 9387.000000,  9418.500000, 9450.000000,  9481.500000, 9513.000000,  9544.500000, 9576.000000,
9607.500000, 9639.000000,  9670.500000, 9702.000000,  9733.500000, 9765.000000,  9796.500000, 9828.000000,
9859.500000,   9891.000000,    9922.500000,   9954.000000,   9985.500000,    10017.000000,   10048.500000,
10080.000000,   10111.500000,  10143.000000,   10174.500000,  10206.000000,   10237.500000,  10269.000000,
10300.500000,   10332.000000,  10363.500000,   10395.000000,  10426.500000,   10458.000000,  10489.500000,
10521.000000,   10552.500000,  10584.000000,   10615.500000,  10647.000000,   10678.500000,  10710.000000,
10741.500000,   10773.000000,  10804.500000,   10836.000000,  10867.500000,   10899.000000,  10930.500000,
10962.000000,   10993.500000,  11025.000000,   11056.500000,  11088.000000,   11119.500000,  11151.000000,
11182.500000,   11214.000000,  11245.500000,   11277.000000,  11308.500000,   11340.000000,  11371.500000,
11403.000000,   11434.500000,  11466.000000,   11497.500000,  11529.000000,   11560.500000,  11592.000000,
11623.500000,   11655.000000,  11686.500000,   11718.000000,  11749.500000,   11781.000000,  11812.500000,
11844.000000,   11875.500000,  11907.000000,   11938.500000,  11970.000000,   12001.500000,  12033.000000,
12064.500000,   12096.000000,  12127.500000,   12159.000000,  12190.500000,   12222.000000,  12253.500000,
12285.000000,   12316.500000,  12348.000000,   12379.500000,  12411.000000,   12442.500000,  12474.000000,
12505.500000,   12537.000000,  12568.500000,   12600.000000,  12631.500000,   12663.000000,  12694.500000,
12726.000000,   12757.500000,  12789.000000,   12820.500000,  12852.000000,   12883.500000,  12915.000000,
12946.500000,   12978.000000,  13009.500000,   13041.000000,  13072.500000,   13104.000000,  13135.500000,
13167.000000,   13198.500000,  13230.000000,   13261.500000,  13293.000000,   13324.500000,  13356.000000,
13387.500000,   13419.000000,  13450.500000,   13482.000000,  13513.500000,   13545.000000,  13576.500000,
13608.000000,   13639.500000,  13671.000000,   13702.500000,  13734.000000,   13765.500000,  13797.000000,
13828.500000,   13860.000000,  13891.500000,   13923.000000,  13954.500000,   13986.000000,  14017.500000,
14049.000000,   14080.500000,  14112.000000,   14143.500000,  14175.000000,   14206.500000,  14238.000000,
14269.500000,   14301.000000,  14332.500000,   14364.000000,  14395.500000,   14427.000000,  14458.500000,
14490.000000,   14521.500000,  14553.000000,   14584.500000,  14616.000000,   14647.500000,  14679.000000,
14710.500000,   14742.000000,  14773.500000,   14805.000000,  14836.500000,   14868.000000,  14899.500000,
14931.000000,   14962.500000,  14994.000000,   15025.500000,  15057.000000,   15088.500000,  15120.000000,
15151.500000,   15183.000000,  15214.500000,   15246.000000,  15277.500000,   15309.000000,  15340.500000,
15372.000000,   15403.500000,  15435.000000,   15466.500000,  15498.000000,   15529.500000,  15561.000000,
15592.500000,   15624.000000,  15655.500000,   15687.000000,  15718.500000,   15750.000000,  15781.500000,
15813.000000,   15844.500000,  15876.000000,   15907.500000,  15939.000000,   15970.500000,  16002.000000,
16033.500000,   16065.000000,  16096.500000,   16128.000000,  16159.500000,   16191.000000,  16222.500000,
16254.000000,   16285.500000,  16317.000000,   16348.500000,  16380.000000,   16411.500000,  16443.000000,
16474.500000,   16506.000000,  16537.500000,   16569.000000,  16600.500000,   16632.000000,  16663.500000,
16695.000000,   16726.500000,  16758.000000,   16789.500000,  16821.000000,   16852.500000,  16884.000000,
16915.500000,   16947.000000,  16978.500000,   17010.000000,  17041.500000,   17073.000000,  17104.500000,
17136.000000,   17167.500000,  17199.000000,   17230.500000,  17262.000000,   17293.500000,  17325.000000,
17356.500000,   17388.000000,  17419.500000,   17451.000000,  17482.500000,   17514.000000,  17545.500000,
17577.000000,   17608.500000,  17640.000000,   17671.500000,  17703.000000,   17734.500000,  17766.000000,
17797.500000,   17829.000000,  17860.500000,   17892.000000,  17923.500000,   17955.000000,  17986.500000,
18018.000000,   18049.500000,  18081.000000,   18112.500000,  18144.000000,   18175.500000,  18207.000000,
18238.500000,   18270.000000,  18301.500000,   18333.000000,  18364.500000,   18396.000000,  18427.500000,
18459.000000,   18490.500000,  18522.000000,   18553.500000,  18585.000000,   18616.500000,  18648.000000,
18679.500000,   18711.000000,  18742.500000,   18774.000000,  18805.500000,   18837.000000,  18868.500000,
18900.000000,   18931.500000,  18963.000000,   18994.500000,  19026.000000,   19057.500000,  19089.000000,
19120.500000,   19152.000000,  19183.500000,   19215.000000,  19246.500000,   19278.000000,  19309.500000,
19341.000000,   19372.500000,  19404.000000,   19435.500000,  19467.000000,   19498.500000,  19530.000000,
19561.500000,   19593.000000,  19624.500000,   19656.000000,  19687.500000,   19719.000000,  19750.500000,
19782.000000,   19813.500000,  19845.000000,   19876.500000,  19908.000000,   19939.500000,  19971.000000,
20002.500000,   20034.000000,  20065.500000,   20097.000000,  20128.500000,   20160.000000,  20191.500000,
20223.000000,   20254.500000,  20286.000000,   20317.500000,  20349.000000,   20380.500000,  20412.000000,
20443.500000,   20475.000000,  20506.500000,   20538.000000,  20569.500000,   20601.000000,  20632.500000,
20664.000000,   20695.500000,  20727.000000,   20758.500000,  20790.000000,   20821.500000,  20853.000000,
20884.500000,   20916.000000,  20947.500000,   20979.000000,  21010.500000,   21042.000000,  21073.500000,
21105.000000,   21136.500000,  21168.000000,   21199.500000,  21231.000000,   21262.500000,  21294.000000,
21325.500000,   21357.000000,  21388.500000,   21420.000000,  21451.500000,   21483.000000,  21514.500000,
21546.000000,   21577.500000,  21609.000000,   21640.500000,  21672.000000,   21703.500000,  21735.000000,
21766.500000,   21798.000000,  21829.500000,   21861.000000,  21892.500000,   21924.000000,  21955.500000,
21987.000000,   22018.500000,  22050.000000,   22081.500000,  22113.000000,   22144.500000,  22176.000000,
22207.500000,   22239.000000,  22270.500000,   22302.000000,  22333.500000,   22365.000000,  22396.500000,
22428.000000,   22459.500000,  22491.000000,   22522.500000,  22554.000000,   22585.500000,  22617.000000,
22648.500000,   22680.000000,  22711.500000,   22743.000000,  22774.500000,   22806.000000,  22837.500000,
22869.000000,   22900.500000,  22932.000000,   22963.500000,  22995.000000,   23026.500000,  23058.000000,
23089.500000,   23121.000000,  23152.500000,   23184.000000,  23215.500000,   23247.000000,  23278.500000,
23310.000000,   23341.500000,  23373.000000,   23404.500000,  23436.000000,   23467.500000,  23499.000000,
23530.500000,   23562.000000,  23593.500000,   23625.000000,  23656.500000,   23688.000000,  23719.500000,
23751.000000,   23782.500000,  23814.000000,   23845.500000,  23877.000000,   23908.500000,  23940.000000,
23971.500000,   24003.000000,  24034.500000,   24066.000000,  24097.500000,   24129.000000,  24160.500000,
24192.000000,   24223.500000,  24255.000000,   24286.500000,  24318.000000,   24349.500000,  24381.000000,
24412.500000,   24444.000000,  24475.500000,   24507.000000,  24538.500000,   24570.000000,  24601.500000,
24633.000000,   24664.500000,  24696.000000,   24727.500000,  24759.000000,   24790.500000,  24822.000000,
24853.500000,   24885.000000,  24916.500000,   24948.000000,  24979.500000,   25011.000000,  25042.500000,
25074.000000,   25105.500000,  25137.000000,   25168.500000,  25200.000000,   25231.500000,  25263.000000,
25294.500000,   25326.000000,  25357.500000,   25389.000000,  25420.500000,   25452.000000,  25483.500000,
25515.000000,   25546.500000,  25578.000000,   25609.500000,  25641.000000,   25672.500000,  25704.000000,
25735.500000,   25767.000000,  25798.500000,   25830.000000,  25861.500000,   25893.000000,  25924.500000,
25956.000000,   25987.500000,  26019.000000,   26050.500000,  26082.000000,   26113.500000,  26145.000000,
26176.500000,   26208.000000,  26239.500000,   26271.000000,  26302.500000,   26334.000000,  26365.500000,
26397.000000,   26428.500000,  26460.000000,   26491.500000,  26523.000000,   26554.500000,  26586.000000,
26617.500000,   26649.000000,  26680.500000,   26712.000000,  26743.500000,   26775.000000,  26806.500000,
26838.000000,   26869.500000,  26901.000000,   26932.500000,  26964.000000,   26995.500000,  27027.000000,
27058.500000,   27090.000000,  27121.500000,   27153.000000,  27184.500000,   27216.000000,  27247.500000,
27279.000000,   27310.500000,  27342.000000,   27373.500000,  27405.000000,   27436.500000,  27468.000000,
27499.500000,   27531.000000,  27562.500000,   27594.000000,  27625.500000,   27657.000000,  27688.500000,
27720.000000,   27751.500000,  27783.000000,   27814.500000,  27846.000000,   27877.500000,  27909.000000,
27940.500000,   27972.000000,  28003.500000,   28035.000000,  28066.500000,   28098.000000,  28129.500000,
28161.000000,   28192.500000,  28224.000000,   28255.500000,  28287.000000,   28318.500000,  28350.000000,
28381.500000,   28413.000000,  28444.500000,   28476.000000,  28507.500000,   28539.000000,  28570.500000,
28602.000000,   28633.500000,  28665.000000,   28696.500000,  28728.000000,   28759.500000,  28791.000000,
28822.500000,   28854.000000,  28885.500000,   28917.000000,  28948.500000,   28980.000000,  29011.500000,
29043.000000,   29074.500000,  29106.000000,   29137.500000,  29169.000000,   29200.500000,  29232.000000,
29263.500000,   29295.000000,  29326.500000,   29358.000000,  29389.500000,   29421.000000,  29452.500000,
29484.000000,   29515.500000,  29547.000000,   29578.500000,  29610.000000,   29641.500000,  29673.000000,
29704.500000,   29736.000000,  29767.500000,   29799.000000,  29830.500000,   29862.000000,  29893.500000,
29925.000000,   29956.500000,  29988.000000,   30019.500000,  30051.000000,   30082.500000,  30114.000000,
30145.500000,   30177.000000,  30208.500000,   30240.000000,  30271.500000,   30303.000000,  30334.500000,
30366.000000,   30397.500000,  30429.000000,   30460.500000,  30492.000000,   30523.500000,  30555.000000,
30586.500000,   30618.000000,  30649.500000,   30681.000000,  30712.500000,   30744.000000,  30775.500000,
30807.000000,   30838.500000,  30870.000000,   30901.500000,  30933.000000,   30964.500000,  30996.000000,
31027.500000,   31059.000000,  31090.500000,   31122.000000,  31153.500000,   31185.000000,  31216.500000,
31248.000000,   31279.500000,  31311.000000,   31342.500000,  31374.000000,   31405.500000,  31437.000000,
31468.500000,   31500.000000,  31531.500000,   31563.000000,  31594.500000,   31626.000000,  31657.500000,
31689.000000,   31720.500000,  31752.000000,   31783.500000,  31815.000000,   31846.500000,  31878.000000,
31909.500000,   31941.000000,  31972.500000,   32004.000000,  32035.500000,   32067.000000,  32098.500000,
32130.000000, 32161.500000, 32193.000000, 32224.500000
};

//-------------------------------------------------------------
// LFO Functions

// update LFO 
float UpdateLFO(float freq);

// triangle wave calc
float TriWave(float pos);

// square wave calc
float SqrWave(float pos);

// saw(samp) wave calc
float SawWave(float pos);

// sine wave calc
float SinWave(float pos);

// exponential wave calc
float ExpWave(float pos);

// logarithmic wave calc
float LogWave(float pos);

// synthesis wave calc1
float SynthWave1(float pos);

// synthesis wave calc2
float SynthWave2(float pos);

// invert float value
float Invert(float x);

// LFO cv generator output LFO channelOffset ~ ch8 
void SteppedLFO(uint8_t channelOffset, bool quantizeOff);

#endif
