/*
 OSCtoCV_GateSequencer.cpp 
*/

#include "mbed.h"
#include "OSCtoCV_GateSequencer.h"
#include "OSCtoCV.h"

//-------------------------------------------------------------
// Gate Sequencer  beat(Note values) length(Gate time) invert(invert Gate)

int GateSeq(uint16_t bpm, uint16_t beat, uint8_t ch, float length, bool invert, bool gatesOff, bool syncoff)
{
    int i;
    static int gatetime[GATE_TOTAL], oldgatetime[GATE_TOTAL];
    static int _bpm, bar, sync24, oldsynctime;
    
    int time = gTimer.read_us();
    
    if (_bpm != bpm)
    {
        if (!bpm)
        {
            beat = NRESET;

        } else {

            bar = (60.0f / bpm) * 4000000;
            //sync24 = (bar / 4) / 24; // sync24 not tested
            
            _bpm = bpm;
        }
    }
    
    switch (beat) // Calculate Note values 
    {
        case NDOT2:
            
            gatetime[ch] = (bar / 4) * 3;
            break;
                
        case NDOT4:
        
            gatetime[ch] = (bar / 8) * 3;
            break;
            
        case NDOT8:
            
            gatetime[ch] = (bar / 16) * 3;
            break;
                
        case NDOT16:
            
            gatetime[ch] = (bar / 32) * 3;
            break;
    
        case NDOT32:
            
            gatetime[ch] = (bar / 64) * 3;
            break;
            
        case NRESET:
        
            gTimer.reset();
            
            for (i = 0; i < GATE_TOTAL; ++i)    // Reset
            {
                oldsynctime = oldgatetime[i] = gatetime[i] = NRESET;
            }

            return 0;

        default:
            
            gatetime[ch] = bar / beat;
            sync24 = bar / 16;
            break;
    }
        
    if (time > oldsynctime + sync24)  // sync24 not tested
    {
        if (!syncoff) 
        {
            oldsynctime = time;
            gCLOCKOUT = true;
            
            midi.sendRealTime(Clock); // MIDI Clock
        }
        
    } else if (time > oldsynctime - (sync24 - 2)) {

        if (!syncoff) 
        {
            gCLOCKOUT = false;
        }
    }

    if (ch == GATE_TOTAL) 
    {
        return -1;
        
    } else if (time > oldgatetime[ch] + gatetime[ch] && !invert) {
        
        oldgatetime[ch] = time;
        
        if (!gatesOff) 
        {
            gGATES[ch] = true;
            
        } else if (ch == SUBGATE) {
            
            gSUBGATE = true;
        }
        
        return 1;
    
    } else if (time > oldgatetime[ch] + gatetime[ch] && invert) {
        
        oldgatetime[ch] = time;
        
        if (!gatesOff) 
        {
            gGATES[ch] = false;
            
        } else if (ch == SUBGATE) {
            
            gSUBGATE = false;
        }
        
        return 0;
        
    } else if (time > oldgatetime[ch] + (gatetime[ch] - gatetime[ch] / length) && !invert) {
        
        if (!gatesOff) 
        {
            gGATES[ch] = false;
            
        } else if (ch == SUBGATE) {
            
            gSUBGATE = false;
        }
        
        return 0;
        
    } else if (time > oldgatetime[ch] + (gatetime[ch] - gatetime[ch] / length) && invert) {
        
        if (!gatesOff) 
        {
            gGATES[ch] = true;
            
        } else if (ch == SUBGATE) {
            
            gSUBGATE = true;
        }
        
        return 1;
        
    } else {
        
        return -1;          
    }
}
