/*
    OSCtoCV Euclidean Sequencer
*/

#pragma O3
#pragma Otime

#ifndef OSCtoCV_EUCLIDEAN_H
#define OSCtoCV_EUCLIDEAN_H

#include "mbed.h"
#include "OSCtoCV.h"

//-------------------------------------------------------------
// Euclidean Sequencer Functions

// Euclidean Sequencer return triggerState
unsigned int EuclideanSeq(int trigger, bool reset, bool gatesoff, bool auto_offset);
    
// Init Euclidean Sequencer
void InitEuclideanSeq(void);

// Euclid calculation function
inline unsigned int Euclid(int n, int k, int o);

// Reads a bit of a number
inline int BitRead(uint16_t b, int bitPos);

// Function to right rotate n by d bits
inline uint16_t BitReadOffset(int shift, uint16_t value, uint16_t pattern_length);

// Function to find the binary length of a number by counting bitwise
inline int findlength(unsigned int bnry);

// Function to concatenate two binary numbers bitwise
inline unsigned int ConcatBin(unsigned int bina, unsigned int binb);

// routine triggered by each beat
inline void Sync(int active_channel, bool gatesoff);

/* 3 functions to read each encoder   
   returns +1, 0 or -1 dependent on direction 
   Contains no internal debounce, so calls should be delayed 
 */

// Check Euclidean Seq N(length) Value
inline int EncodeReadN(int ch);
inline int EncodeReadK(int ch);
inline int EncodeReadO(int ch);

#endif
