/*
 OSCtoCV.cpp 
*/

#include "mbed.h"
#include "OSCtoCV.h"

//-------------------------------------------------------------
// Global Variables

// Silentway Calibration Data Mapping
// http://www.expert-sleepers.co.uk/silentway.html

//  Chromatic Scale
const float calibMap1[QUAN_RES1] = {
0.00076928f,   0.00900736f,   0.01724544f,   0.02548352f,   0.03372160f,
0.04195968f,   0.05019776f,   0.05843584f,   0.06667392f,   0.07491200f,
0.08315008f,   0.09138816f,   0.09962624f,   0.10786432f,   0.11610240f,
0.12434047f,   0.13258974f,   0.14083999f,   0.14909023f,   0.15734047f,
0.16559070f,   0.17384095f,   0.18209119f,   0.19034143f,   0.19859168f,
0.20684192f,   0.21509215f,   0.22334240f,   0.23159264f,   0.23984288f,
0.24809311f,   0.25634655f,   0.26460093f,   0.27285531f,   0.28110969f,
0.28936407f,   0.29761845f,   0.30587283f,   0.31412721f,   0.32238159f,
0.33063596f,   0.33889034f,   0.34714472f,   0.35539910f,   0.36365348f,
0.37190786f,   0.38017464f,   0.38844886f,   0.39672306f,   0.40499726f,
0.41327149f,   0.42154568f,   0.42981988f,   0.43809411f,   0.44636831f,
0.45464250f,   0.46291673f,   0.47119093f,   0.47946513f,   0.48773935f,
0.49601355f,   0.50430328f,   0.51260746f,   0.52091163f,   0.52921581f,
0.53751999f,   0.54582411f,   0.55412829f,   0.56243247f,   0.57073665f,
0.57904083f,   0.58734500f,   0.59564912f,   0.60395330f,   0.61225748f,
0.62056166f,   0.62890279f,   0.63728637f,   0.64566994f,   0.65405351f,
0.66243708f,   0.67082065f,   0.67920423f,   0.68758780f,   0.69597137f,
0.70435494f,   0.71273851f,   0.72112209f,   0.72950566f,   0.73788923f,
0.74627280f,   0.75476575f,   0.76334614f,   0.77192658f,   0.78050703f,
0.78908741f,   0.79766786f,   0.80624831f,   0.81482869f,   0.82340914f,
0.83198959f,   0.84056997f,   0.84915042f,   0.85773087f,   0.86631125f,
0.87489170f,   0.88425636f,   0.89363104f,   0.90300572f,   0.91238040f,
0.92175508f,   0.93112975f,   0.94050443f,   0.94987911f,   0.95925385f,
0.96862853f
};

//  Major Scale
const float calibMap2[QUAN_RES2] = {
calibMap1[0], calibMap1[2], calibMap1[4], calibMap1[5], calibMap1[7],
calibMap1[9], calibMap1[11], calibMap1[12], calibMap1[14], calibMap1[16],
calibMap1[17], calibMap1[19], calibMap1[21], calibMap1[23], calibMap1[24],
calibMap1[26], calibMap1[28], calibMap1[29], calibMap1[31], calibMap1[33],
calibMap1[35], calibMap1[36], calibMap1[38], calibMap1[40], calibMap1[41],
calibMap1[43], calibMap1[45], calibMap1[47], calibMap1[48], calibMap1[50],
calibMap1[52], calibMap1[53], calibMap1[55], calibMap1[57], calibMap1[59],
calibMap1[60], calibMap1[62], calibMap1[64], calibMap1[65], calibMap1[67],
calibMap1[69], calibMap1[71], calibMap1[72], calibMap1[74], calibMap1[76],
calibMap1[77], calibMap1[79], calibMap1[81], calibMap1[83], calibMap1[84],
calibMap1[86], calibMap1[88], calibMap1[89], calibMap1[91], calibMap1[93],
calibMap1[95], calibMap1[96], calibMap1[98], calibMap1[100], calibMap1[101],
calibMap1[103], calibMap1[105], calibMap1[107], calibMap1[108], calibMap1[110],
calibMap1[112], calibMap1[113], calibMap1[115]
};

//  M7(9)
const float calibMap3[QUAN_RES3] = {
calibMap1[0],  calibMap1[4], calibMap1[7], calibMap1[11], calibMap1[12], 
calibMap1[14], calibMap1[16], calibMap1[19], calibMap1[23], calibMap1[24],
calibMap1[26], calibMap1[28], calibMap1[31], calibMap1[35], calibMap1[36], 
calibMap1[38], calibMap1[40], calibMap1[43], calibMap1[47], calibMap1[48], 
calibMap1[50], calibMap1[52], calibMap1[55], calibMap1[59], calibMap1[60], 
calibMap1[62], calibMap1[64], calibMap1[67], calibMap1[71], calibMap1[72], 
calibMap1[76], calibMap1[79], calibMap1[83], calibMap1[84], calibMap1[86], 
calibMap1[88], calibMap1[91], calibMap1[95], calibMap1[96], calibMap1[100],
calibMap1[103], calibMap1[107], calibMap1[108], calibMap1[110], calibMap1[112], 
calibMap1[115]
};

//  m7(9)
const float calibMap4[QUAN_RES4] = {
calibMap1[0], calibMap1[3], calibMap1[7], calibMap1[10], calibMap1[12], 
calibMap1[15], calibMap1[19], calibMap1[22], calibMap1[26], calibMap1[27], 
calibMap1[31], calibMap1[34], calibMap1[36], calibMap1[38], calibMap1[39], 
calibMap1[43], calibMap1[46], calibMap1[50], calibMap1[53], calibMap1[55], 
calibMap1[58], calibMap1[60], calibMap1[63], calibMap1[67], calibMap1[70], 
calibMap1[72], calibMap1[74], calibMap1[75], calibMap1[79], calibMap1[82], 
calibMap1[86], calibMap1[89], calibMap1[91], calibMap1[94], calibMap1[96], 
calibMap1[99],  calibMap1[103], calibMap1[106], calibMap1[110], calibMap1[113]
};

//  Dorian Scale
const float calibMap5[QUAN_RES5] = {
calibMap1[0], calibMap1[2], calibMap1[3], calibMap1[5], calibMap1[7],
calibMap1[9], calibMap1[10], calibMap1[12], calibMap1[14], calibMap1[15],
calibMap1[17], calibMap1[19], calibMap1[20], calibMap1[21], calibMap1[24],
calibMap1[26], calibMap1[27], calibMap1[29], calibMap1[31], calibMap1[33],
calibMap1[34], calibMap1[36], calibMap1[38], calibMap1[39], calibMap1[41],
calibMap1[43], calibMap1[45], calibMap1[46], calibMap1[48], calibMap1[50],
calibMap1[51], calibMap1[53], calibMap1[55], calibMap1[57], calibMap1[58],
calibMap1[60], calibMap1[62], calibMap1[63], calibMap1[65], calibMap1[67],
calibMap1[69], calibMap1[70], calibMap1[72], calibMap1[74], calibMap1[75],
calibMap1[77], calibMap1[79], calibMap1[81], calibMap1[82], calibMap1[84],
calibMap1[86], calibMap1[87], calibMap1[89], calibMap1[91], calibMap1[93],
calibMap1[94], calibMap1[96], calibMap1[98], calibMap1[99], calibMap1[101],
calibMap1[103], calibMap1[105], calibMap1[106], calibMap1[108], calibMap1[110],
calibMap1[111], calibMap1[113], calibMap1[115]
};

//  Minor Scale
const float calibMap6[QUAN_RES6] = {
calibMap1[0], calibMap1[2], calibMap1[3], calibMap1[5], calibMap1[7],
calibMap1[8], calibMap1[10], calibMap1[12], calibMap1[14], calibMap1[15],
calibMap1[17], calibMap1[19], calibMap1[20], calibMap1[22], calibMap1[24],
calibMap1[26], calibMap1[27], calibMap1[29], calibMap1[31], calibMap1[32],
calibMap1[34], calibMap1[36], calibMap1[38], calibMap1[39], calibMap1[41],
calibMap1[43], calibMap1[44], calibMap1[46], calibMap1[48], calibMap1[50],
calibMap1[51], calibMap1[53], calibMap1[55], calibMap1[56], calibMap1[58],
calibMap1[60], calibMap1[62], calibMap1[63], calibMap1[65], calibMap1[67],
calibMap1[68], calibMap1[70], calibMap1[72], calibMap1[74], calibMap1[75],
calibMap1[77], calibMap1[79], calibMap1[80], calibMap1[82], calibMap1[84],
calibMap1[86], calibMap1[87], calibMap1[89], calibMap1[91], calibMap1[92],
calibMap1[94], calibMap1[96], calibMap1[98], calibMap1[99], calibMap1[101],
calibMap1[103], calibMap1[104], calibMap1[106], calibMap1[108], calibMap1[110],
calibMap1[111], calibMap1[113], calibMap1[115]
};

//  5th
const float calibMap7[QUAN_RES7] = {
calibMap1[0], calibMap1[7], calibMap1[14], calibMap1[21], calibMap1[28],
calibMap1[35], calibMap1[42], calibMap1[49], calibMap1[56], calibMap1[63],
calibMap1[70], calibMap1[77], calibMap1[84], calibMap1[91], calibMap1[98],
calibMap1[105]
};

//  Whole tone
const float calibMap8[QUAN_RES8] = {
calibMap1[0], calibMap1[1], calibMap1[2], calibMap1[6], calibMap1[8],
calibMap1[10], calibMap1[12], calibMap1[14], calibMap1[16], calibMap1[18],
calibMap1[20], calibMap1[22], calibMap1[24], calibMap1[26], calibMap1[28],
calibMap1[30], calibMap1[32], calibMap1[34], calibMap1[36], calibMap1[38],
calibMap1[40], calibMap1[42], calibMap1[44], calibMap1[46], calibMap1[48],
calibMap1[50], calibMap1[52], calibMap1[54], calibMap1[56], calibMap1[58],
calibMap1[60], calibMap1[62], calibMap1[64], calibMap1[66], calibMap1[68],
calibMap1[70], calibMap1[72], calibMap1[74], calibMap1[76], calibMap1[78],
calibMap1[80], calibMap1[82], calibMap1[84], calibMap1[86], calibMap1[88],
calibMap1[90], calibMap1[92], calibMap1[94], calibMap1[96], calibMap1[98],
calibMap1[100], calibMap1[102], calibMap1[104], calibMap1[106], calibMap1[108],
calibMap1[110], calibMap1[112], calibMap1[114]
};

//-------------------------------------------------------------
// Global Variables

float gOSC_cv[8];
float gSeq_cv[16];
float g185_cv[8];
float gGlide;

// Sub Mode Status
int gSubModeCount1 = -1;
int gSubModeCount2 = -1;

// Variables for Sequencer
float gPulseCount[8] = {0};
float gGateMode[16] = {0};
float gGateMode185[8] = {0};
float gSlide[16];
float gSlide185[8];
float gAccent[16] = {0};
float gAccent185[8] = {0};

float gPulseCountBeats[16] = {0};
float gBeatsLevel[8];
float gBeatsDecay[8];
unsigned int gBeatsMatrix[8][16] = {{0}};

// Euclidean SEQ Variables
float gEucA[6], gEucB[6];

// Variables for Control
/*
gCtrl[0] /ctrl1 BPM
gCtrl[1] /ctrl2 Quantize mode
gCtrl[3] /ctrl4 Glide
gCtrl[4] /ctrl5 Shift CV Seq Reset Count
gCtrl[5] /ctrl6 M185 Seq Reset Count
gCtrl[6] /ctrl7 Gate Length
gCtrl[7] /ctrl8 Beats Seq Reset Count

gCtrlSW[0] /ctrlsw1 Sequencer STOP
gCtrlSW[1] /ctrlsw2 Euclidean Sequencer reset
gCtrlSW[2] /ctrlsw3 Sequencer Loop
gCtrlSW[3] /ctrlsw4 Euclid Seq ON
gCtrlSW[4] /ctrlsw5 ASR Analog Mode
gCtrlSW[5] /ctrlsw6 Beats Sequencer Random Vel

gArdPot[0] /pot1  Arduino pot1
gArdPot[1] /pot2  Arduino pot2
gArdSW[0] /sw1  Arduino sw1
gArdSW[1] /sw2  Arduino sw2
*/

float gCtrl[8] = {0.398f, 0, 0, 0, 1.0f, 1.0f, 1.0f, 1.0f};
bool  gCtrlSW[8] = {false};

// Variables for Arduino
uint16_t gArdCV[4] = {0};
float gArdPot[2] = {408.0f, 350};
bool gArdSW[2] = {false};

//-------------------------------------------------------------
// mbed Functions

TextLCD      gLCD(p9, p10, p11, p12, p13, p14); // rs, e, d4-d7

BurstSPI     gSPI(p5,p6,p7);    // SPI (p6 unconnected)

FastOut<p15> gSYNCMODE;         // SYNC DAC8568
FastOut<p16> gLDAC;             // LDAC DAC8568

DigitalOut   gGATES[4] = {p21, p22, p23, p24};   // GateOut
FastOut<p19> gSUBGATE;                           // SubGateOut
FastOut<p25> gCLOCKOUT;                          // ClockOut

AnalogOut    gAOUT(p18);

AnalogIn gAIN(p17);
DebouncedInterrupt  gSW(p30);   // Mode SW

// MIDI OUT
MIDI midi(p28, p27);

Timer        gTimer;     // Timer
Ticker       gPoller;    // Ticker for Polling

// Ethernet
#ifdef DHCP
EthernetNetIf gEth;
#else
EthernetNetIf gEth(
                   IpAddr(192,168,1,6),
                   IpAddr(255,255,255,0),
                   IpAddr(192,168,1,1),
                   IpAddr(192,168,1,1)
                   );
#endif

// touchOSC Address
uint8_t touchOSCAddress[] = {192, 168, 1, 7};
int touchOSCPort = TOSC_PORT;

// Set OSC message for sending 
OSCClass osc;
OSCMessage sendMes;

//-------------------------------------------------------------
// SPI Transfer
// DAC8568 data word length 32bit (8bit shift out)

void UpdateCV(unsigned int control, unsigned int ch, const unsigned int *data)
{

    switch (control)
    {
        case WRITE_UPDATE_N:

            gSYNCMODE = _DISABLE;
            gSPI.write(00000000|control);            // padding at beginning of byte and control bits
            gSPI.write(ch << 4 | *data >> 12);       // address(ch) bits
            gSPI.write((*data << 4) >> 8);           // middle 8 bits of data
            gSPI.write((*data << 12) >> 8 | 00001111);
            gSYNCMODE = _ENABLE;
            gLDAC = _DISABLE;
            gLDAC = _ENABLE;
            
            break;

        case RESET:

            gSYNCMODE = _DISABLE;
            gSPI.write(00000111);   // Software RESET
            gSPI.write(00000000);
            gSPI.write(00000000);
            gSPI.write(00000000);
            gSYNCMODE = _ENABLE;
            
            break;

        case CLR:
        
            gSYNCMODE = _DISABLE;
            gSPI.write(00000101);   // CLR Register
            gSPI.write(00000000);
            gSPI.write(00000000);
            gSPI.write(00000011);   // Ignore CLR Pin
            gSYNCMODE = _ENABLE;
            
            break;
    }
}

//-------------------------------------------------------------
// CV Meter TextLCD bar meter

void UpdateCVMeter(unsigned int ch, const unsigned int *level)
{       
    gLCD.locate ( ch, 0 );
    gLCD.putc(*level * 0.0002192f);     // put custom char
}

//-------------------------------------------------------------
// Check subMode1(gArdSW[0]) (subMode Status & Text LCD Update)

int CheckSubMode1(void)
{
    static int lastSWState = -1;
    
    if (gArdSW[0] != lastSWState)
    {
        lastSWState = gArdSW[0];
        
        if (gSubModeCount1 < SUBMODE1_TOTAL - 1) 
        {   
            ++gSubModeCount1;
        
        } else {
            
            gSubModeCount1 = 0;
        }
    
    }
    
    return gSubModeCount1;
}

//-------------------------------------------------------------
// Check subMode2(gArdSW[1]) (subMode Status & Text LCD Update)

int CheckSubMode2(void)
{
    static int lastSWState = -1;
    
    if (gArdSW[1] != lastSWState)
    {
        lastSWState = gArdSW[1];
        
        if (gSubModeCount2 < SUBMODE2_TOTAL - 1) 
        {   
            ++gSubModeCount2;
        
        } else {
            
            gSubModeCount2 = 0;
        }
    
    }
    
    return gSubModeCount2;
}

//-------------------------------------------------------------
// Update subMode Text LCD
void UpdateSubModeLCD(const char * subModeName)
{
    gLCD.locate( 0, 1 );
    gLCD.printf("        ");
        
    gLCD.locate( 0, 1 );
    gLCD.printf("%s", subModeName);
    
    sendMes.setTopAddress("/submode");
    sendMes.setArgs("s", subModeName);
    
    osc.sendOsc(&sendMes);
}
