/*
    OSCtoCV Shift Sequencer & M185 Sequencer
*/

#pragma O3
#pragma Otime

#ifndef OSCtoCV_SEQUENCER_h
#define OSCtoCV_SEQUENCER_h

#include "mbed.h"


//-------------------------------------------------------------
// Sequencer Functions

// Sequence & Shift Out CV sequence cv out ch1 ~ channelRange
void ShiftCVSeq(int trigger, bool reset, uint8_t channelRange);

// M185 Sequencer sequence cv out ch1 ~ channelRange
void M185Seq(int trigger, bool reset, uint8_t channelRange);

// Polyphonic CV sequence cv out ch1 ~ channelRange
void PolyM185Seq(int trigger, bool reset, uint8_t channelRange);

// shift cv seq ch1 ~ ch4 m185 seq ch5 ~ ch8
void PolyCVSeq(int trigger, bool reset);

// 8ch drum track(midi & gate) sequecer // gatesOff(Mute GateOut(midi out only)) return triggerState
bool BeatsSeq(int trigger, bool reset, bool gatesOff);

// check resetCount
void CheckResetCount(uint8_t resetCount, uint8_t mode);

// check Analog Mode
void CheckAnalogMode(void);

// Send Sequencer Status to touchOSC (mode = SHIFTSEQ or M185SEQ or BEATSSEQ)
inline void SendCtrlState(uint8_t step, uint8_t gateMode, uint8_t stepCount, uint8_t mode);

#endif
