// 
// OSC Receiver
//
// date: 2011/1/10
// version: 0.7
// written by: xshige
//
// please find OSC Sender program at the bottom of this file
//
/*
  The followings are supported:
 
    Transport Type: 
      UDP
 
    Features: 
     Packet Parsing (Client)
     Not Supported:Packet Construction (Server)
     Bundle NOT Support
     Timetag NOT Support
 
    Type Support: 
     i: int32
     b: blob
     s: string
     f: float32
     m: MIDI message(port id, status byte, data1, data2) // I don't know the detail
 
*/

#pragma O3
#pragma Otime 
 
#include "mbed.h"
#include "OSCReceiver.h" // Add by RadioJunkBox 2012/05/16 

inline int getOSCmsg(char , union OSCarg);
inline size_t strlength(const char *);

size_t strlength(const char *s) 
{
    size_t len = 0;
    
    for(;;) 
    {
        unsigned x = *(unsigned*)s;
        if((x & 0xFF) == 0) return len;
        if((x & 0xFF00) == 0) return len + 1;
        if((x & 0xFF0000) == 0) return len + 2;
        if((x & 0xFF000000) == 0) return len + 3;
        s += 4, len += 4;
    }
}
    
int getOSCmsg(const char *packet, union OSCarg *msg)
{
// Caution: the returned result points to packet as blobs or strings (not newly allocatd)
    char *p, *typeTag; 
    uint8_t n, str1 = 0;
    
    if(packet[0] != '/')
    {
        return -1;
    }
    
    msg[0].address = packet; // address
    msg[1].typeTag = packet + (((strlength(msg[0].s) >> 2) + 1) << 2);//typeTag
    typeTag = msg[1].s + 1;   // skip ','
    p = msg[1].s + (((strlength(msg[1].s) >> 2) + 1) << 2);
    
    str1 = strlength(typeTag);
        
    for(n = 0; n < str1; ++n)
    {
        switch (typeTag[n])
        {
            case 's':
                msg[n+2].s = p;
                p += (((strlength(msg[n+2].s) >> 2) + 1) << 2);
                break;
        
            case 'i':
            case 'f':
                // chang endian (big to little)
                msg[n+2]._b[3] = p[0]; 
                msg[n+2]._b[2] = p[1]; 
                msg[n+2]._b[1] = p[2];
                msg[n+2]._b[0] = p[3];
        
                p += 4;
                break;
                
            case 'b':
                // chang endian (big to little)
                // get lenth of blog (copy to msg[n].blog.len)
                msg[n+2]._b[3] = p[0]; 
                msg[n+2]._b[2] = p[1]; 
                msg[n+2]._b[1] = p[2];
                msg[n+2]._b[0] = p[3];
        
                p += 4;  
                // get ponter of blog (copy to msg[n].blog.p)
                msg[n+2].blob.p = p;
        
                p += (((msg[n+2].blob.len >> 2) + 1) << 2);
                break;
        
            case 'm':
                // get midi data (copy to msg[n].m[])
                msg[n+2].m[0] = p[0]; 
                msg[n+2].m[1] = p[1]; 
                msg[n+2].m[2] = p[2];
                msg[n+2].m[3] = p[3];
        
                p += 4; 
                break;
            
            default:
                return -1;
            
        }
    };
    
    return 1;
}   