#include "mbed.h"
#include "mbedOSC.h"

//// ETHERNET

// Ethernet can be created with *either* an address assigned by DHCP or a static IP address. Uncomment the define line for DHCP
//#define DHCP
#ifdef DHCP
EthernetNetIf eth;
#else
EthernetNetIf eth(
    IpAddr(192,168,1,6), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,1,1), //Gateway
    IpAddr(192,168,1,1)  //DNS
);
#endif

//// OSC

// The object to do the work of sending and receiving
OSCClass oscs;

// The message objects to send and receive with
OSCMessage recMes;
OSCMessage sendsMes;
// Setting - The port we're listening to on the mbed for OSC messages
int  mbedListenPort  = 12345;

// Setting - The address and port we're going to send to, from the mbed
uint8_t destIp[]  = { 192, 168, 1, 2};
int  destPort = 8000;

//// mbed input

//// Our messageReceivedCallback function
void processOSC() {

    // If this function has been called, the OSC message just received will have been parsed into our recMes OSCMessage object
    // Note we can access recMes here, outside of the main loop, as we created it as a global variable.

    // TASK: If this message one we want, do something about it.
    // In this example we're listening for messages with a top address of "mbed".
    // Note the strcmp function returns 0 if identical, so !strcmp is true if the two strings are the same
    if ( !strcmp( recMes.getAddress(0) , "mode" ) ) {
        
        sendsMes.setTopAddress("/reset");
        sendsMes.setArgs("s", recMes.getArgString(0));
        oscs.sendOsc(&sendsMes);
        
    } else if (!strcmp( recMes.getAddress(0) , "ctrl7" ) ) {
        
        sendsMes.setTopAddress("/scale");
        sendsMes.setArgs("f", recMes.getArgFloat(0));
        oscs.sendOsc(&sendsMes);
    } 

}

////  M A I N
int main() {


    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        return -1;
    }

    //// TASK: Set up OSC message sending

    // In the OSC message container we've made for send messages, set where we want it to go:
    sendsMes.setIp( destIp );
    sendsMes.setPort( destPort );

    //// TASK: Set up OSC message receiving

    // In the OSC send/receive object...
    // Set the OSC message container for it to parse received messages into
    oscs.setReceiveMessage(&recMes);

    // Tell it to begin listening for OSC messages at the port specified (the IP address we know already, it's the mbed's!).
    oscs.begin(mbedListenPort);

    // Rather than constantly checking to see whether there are new messages waiting, the object can call some code of ours to run when a message is received.
    // This line does that, attaching a callback function we've written before getting to this point, in this case it's called processOSC
    // For more info how this works, see http://mbed.org/cookbook/FunctionPointer
    oscs.messageReceivedCallback.attach(&processOSC);



    // We've finished setting up, now loop this forever...
    while (true) {
        // This polls the network connection for new activity, without keeping on calling this you won't receive any OSC!
        Net::poll();
    }
}
